/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApproveAssignmentRequest extends MTurkRequest implements
        ToCopyableBuilder<ApproveAssignmentRequest.Builder, ApproveAssignmentRequest> {
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentId").getter(getter(ApproveAssignmentRequest::assignmentId))
            .setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> REQUESTER_FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterFeedback").getter(getter(ApproveAssignmentRequest::requesterFeedback))
            .setter(setter(Builder::requesterFeedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterFeedback").build()).build();

    private static final SdkField<Boolean> OVERRIDE_REJECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OverrideRejection").getter(getter(ApproveAssignmentRequest::overrideRejection))
            .setter(setter(Builder::overrideRejection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideRejection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_ID_FIELD,
            REQUESTER_FEEDBACK_FIELD, OVERRIDE_REJECTION_FIELD));

    private final String assignmentId;

    private final String requesterFeedback;

    private final Boolean overrideRejection;

    private ApproveAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentId = builder.assignmentId;
        this.requesterFeedback = builder.requesterFeedback;
        this.overrideRejection = builder.overrideRejection;
    }

    /**
     * <p>
     * The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
     * </p>
     * 
     * @return The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
     */
    public final String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * A message for the Worker, which the Worker can see in the Status section of the web site.
     * </p>
     * 
     * @return A message for the Worker, which the Worker can see in the Status section of the web site.
     */
    public final String requesterFeedback() {
        return requesterFeedback;
    }

    /**
     * <p>
     * A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to
     * <code>False</code>.
     * </p>
     * 
     * @return A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to
     *         <code>False</code>.
     */
    public final Boolean overrideRejection() {
        return overrideRejection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(overrideRejection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApproveAssignmentRequest)) {
            return false;
        }
        ApproveAssignmentRequest other = (ApproveAssignmentRequest) obj;
        return Objects.equals(assignmentId(), other.assignmentId())
                && Objects.equals(requesterFeedback(), other.requesterFeedback())
                && Objects.equals(overrideRejection(), other.overrideRejection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApproveAssignmentRequest").add("AssignmentId", assignmentId())
                .add("RequesterFeedback", requesterFeedback()).add("OverrideRejection", overrideRejection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "RequesterFeedback":
            return Optional.ofNullable(clazz.cast(requesterFeedback()));
        case "OverrideRejection":
            return Optional.ofNullable(clazz.cast(overrideRejection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApproveAssignmentRequest, T> g) {
        return obj -> g.apply((ApproveAssignmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, ApproveAssignmentRequest> {
        /**
         * <p>
         * The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
         * </p>
         * 
         * @param assignmentId
         *        The ID of the assignment. The assignment must correspond to a HIT created by the Requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * A message for the Worker, which the Worker can see in the Status section of the web site.
         * </p>
         * 
         * @param requesterFeedback
         *        A message for the Worker, which the Worker can see in the Status section of the web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterFeedback(String requesterFeedback);

        /**
         * <p>
         * A flag indicating that an assignment should be approved even if it was previously rejected. Defaults to
         * <code>False</code>.
         * </p>
         * 
         * @param overrideRejection
         *        A flag indicating that an assignment should be approved even if it was previously rejected. Defaults
         *        to <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideRejection(Boolean overrideRejection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String assignmentId;

        private String requesterFeedback;

        private Boolean overrideRejection;

        private BuilderImpl() {
        }

        private BuilderImpl(ApproveAssignmentRequest model) {
            super(model);
            assignmentId(model.assignmentId);
            requesterFeedback(model.requesterFeedback);
            overrideRejection(model.overrideRejection);
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getRequesterFeedback() {
            return requesterFeedback;
        }

        public final void setRequesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
        }

        @Override
        public final Builder requesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
            return this;
        }

        public final Boolean getOverrideRejection() {
            return overrideRejection;
        }

        public final void setOverrideRejection(Boolean overrideRejection) {
            this.overrideRejection = overrideRejection;
        }

        @Override
        public final Builder overrideRejection(Boolean overrideRejection) {
            this.overrideRejection = overrideRejection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApproveAssignmentRequest build() {
            return new ApproveAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
