/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateInput> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputName").getter(TemplateInput.getter(TemplateInput::inputName)).setter(TemplateInput.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(TemplateInput.getter(TemplateInput::dataTypeAsString)).setter(TemplateInput.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(TemplateInput.getter(TemplateInput::required)).setter(TemplateInput.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, DATA_TYPE_FIELD, REQUIRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputName;
    private final String dataType;
    private final Boolean required;

    private TemplateInput(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.dataType = builder.dataType;
        this.required = builder.required;
    }

    public final String inputName() {
        return this.inputName;
    }

    public final DataType dataType() {
        return DataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Boolean required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateInput)) {
            return false;
        }
        TemplateInput other = (TemplateInput)obj;
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.required(), other.required());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateInput").add("InputName", (Object)this.inputName()).add("DataType", (Object)this.dataTypeAsString()).add("Required", (Object)this.required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateInput, T> g) {
        return obj -> g.apply((TemplateInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputName;
        private String dataType;
        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateInput model) {
            this.inputName(model.inputName);
            this.dataType(model.dataType);
            this.required(model.required);
        }

        public final String getInputName() {
            return this.inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public TemplateInput build() {
            return new TemplateInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateInput> {
        public Builder inputName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(DataType var1);

        public Builder required(Boolean var1);
    }
}

