/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.ImportErrorData;
import software.amazon.awssdk.services.mgn.model.ImportErrorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTaskError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportTaskError> {
    private static final SdkField<ImportErrorData> ERROR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorData").getter(ImportTaskError.getter(ImportTaskError::errorData)).setter(ImportTaskError.setter(Builder::errorData)).constructor(ImportErrorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorData").build()}).build();
    private static final SdkField<String> ERROR_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorDateTime").getter(ImportTaskError.getter(ImportTaskError::errorDateTime)).setter(ImportTaskError.setter(Builder::errorDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDateTime").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorType").getter(ImportTaskError.getter(ImportTaskError::errorTypeAsString)).setter(ImportTaskError.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DATA_FIELD, ERROR_DATE_TIME_FIELD, ERROR_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImportErrorData errorData;
    private final String errorDateTime;
    private final String errorType;

    private ImportTaskError(BuilderImpl builder) {
        this.errorData = builder.errorData;
        this.errorDateTime = builder.errorDateTime;
        this.errorType = builder.errorType;
    }

    public final ImportErrorData errorData() {
        return this.errorData;
    }

    public final String errorDateTime() {
        return this.errorDateTime;
    }

    public final ImportErrorType errorType() {
        return ImportErrorType.fromValue(this.errorType);
    }

    public final String errorTypeAsString() {
        return this.errorType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTaskError)) {
            return false;
        }
        ImportTaskError other = (ImportTaskError)obj;
        return Objects.equals(this.errorData(), other.errorData()) && Objects.equals(this.errorDateTime(), other.errorDateTime()) && Objects.equals(this.errorTypeAsString(), other.errorTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTaskError").add("ErrorData", (Object)this.errorData()).add("ErrorDateTime", (Object)this.errorDateTime()).add("ErrorType", (Object)this.errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorData": {
                return Optional.ofNullable(clazz.cast(this.errorData()));
            }
            case "errorDateTime": {
                return Optional.ofNullable(clazz.cast(this.errorDateTime()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTaskError, T> g) {
        return obj -> g.apply((ImportTaskError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImportErrorData errorData;
        private String errorDateTime;
        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTaskError model) {
            this.errorData(model.errorData);
            this.errorDateTime(model.errorDateTime);
            this.errorType(model.errorType);
        }

        public final ImportErrorData.Builder getErrorData() {
            return this.errorData != null ? this.errorData.toBuilder() : null;
        }

        public final void setErrorData(ImportErrorData.BuilderImpl errorData) {
            this.errorData = errorData != null ? errorData.build() : null;
        }

        @Override
        public final Builder errorData(ImportErrorData errorData) {
            this.errorData = errorData;
            return this;
        }

        public final String getErrorDateTime() {
            return this.errorDateTime;
        }

        public final void setErrorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
        }

        @Override
        public final Builder errorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ImportErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        public ImportTaskError build() {
            return new ImportTaskError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportTaskError> {
        public Builder errorData(ImportErrorData var1);

        default public Builder errorData(Consumer<ImportErrorData.Builder> errorData) {
            return this.errorData((ImportErrorData)((ImportErrorData.Builder)ImportErrorData.builder().applyMutation(errorData)).build());
        }

        public Builder errorDateTime(String var1);

        public Builder errorType(String var1);

        public Builder errorType(ImportErrorType var1);
    }
}

