/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchConfigurationTemplateResponse extends MgnResponse implements
        ToCopyableBuilder<CreateLaunchConfigurationTemplateResponse.Builder, CreateLaunchConfigurationTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("associatePublicIpAddress")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build())
            .build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bootMode").getter(getter(CreateLaunchConfigurationTemplateResponse::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()).build();

    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(CreateLaunchConfigurationTemplateResponse::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(CreateLaunchConfigurationTemplateResponse::copyTags))
            .setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<String> EC2_LAUNCH_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2LaunchTemplateID").getter(getter(CreateLaunchConfigurationTemplateResponse::ec2LaunchTemplateID))
            .setter(setter(Builder::ec2LaunchTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplateID").build())
            .build();

    private static final SdkField<Boolean> ENABLE_MAP_AUTO_TAGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableMapAutoTagging").getter(getter(CreateLaunchConfigurationTemplateResponse::enableMapAutoTagging))
            .setter(setter(Builder::enableMapAutoTagging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMapAutoTagging").build())
            .build();

    private static final SdkField<LaunchTemplateDiskConf> LARGE_VOLUME_CONF_FIELD = SdkField
            .<LaunchTemplateDiskConf> builder(MarshallingType.SDK_POJO).memberName("largeVolumeConf")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::largeVolumeConf)).setter(setter(Builder::largeVolumeConf))
            .constructor(LaunchTemplateDiskConf::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeVolumeConf").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationTemplateID")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::launchConfigurationTemplateID))
            .setter(setter(Builder::launchConfigurationTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID")
                    .build()).build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(CreateLaunchConfigurationTemplateResponse::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(CreateLaunchConfigurationTemplateResponse::licensing))
            .setter(setter(Builder::licensing)).constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<String> MAP_AUTO_TAGGING_MPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapAutoTaggingMpeID").getter(getter(CreateLaunchConfigurationTemplateResponse::mapAutoTaggingMpeID))
            .setter(setter(Builder::mapAutoTaggingMpeID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapAutoTaggingMpeID").build())
            .build();

    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField
            .<PostLaunchActions> builder(MarshallingType.SDK_POJO).memberName("postLaunchActions")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::postLaunchActions))
            .setter(setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()).build();

    private static final SdkField<LaunchTemplateDiskConf> SMALL_VOLUME_CONF_FIELD = SdkField
            .<LaunchTemplateDiskConf> builder(MarshallingType.SDK_POJO).memberName("smallVolumeConf")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::smallVolumeConf)).setter(setter(Builder::smallVolumeConf))
            .constructor(LaunchTemplateDiskConf::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeConf").build()).build();

    private static final SdkField<Long> SMALL_VOLUME_MAX_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("smallVolumeMaxSize").getter(getter(CreateLaunchConfigurationTemplateResponse::smallVolumeMaxSize))
            .setter(setter(Builder::smallVolumeMaxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeMaxSize").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(CreateLaunchConfigurationTemplateResponse::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BOOT_MODE_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD,
            EC2_LAUNCH_TEMPLATE_ID_FIELD, ENABLE_MAP_AUTO_TAGGING_FIELD, LARGE_VOLUME_CONF_FIELD,
            LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, MAP_AUTO_TAGGING_MPE_ID_FIELD,
            POST_LAUNCH_ACTIONS_FIELD, SMALL_VOLUME_CONF_FIELD, SMALL_VOLUME_MAX_SIZE_FIELD, TAGS_FIELD,
            TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private final String arn;

    private final Boolean associatePublicIpAddress;

    private final String bootMode;

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final String ec2LaunchTemplateID;

    private final Boolean enableMapAutoTagging;

    private final LaunchTemplateDiskConf largeVolumeConf;

    private final String launchConfigurationTemplateID;

    private final String launchDisposition;

    private final Licensing licensing;

    private final String mapAutoTaggingMpeID;

    private final PostLaunchActions postLaunchActions;

    private final LaunchTemplateDiskConf smallVolumeConf;

    private final Long smallVolumeMaxSize;

    private final Map<String, String> tags;

    private final String targetInstanceTypeRightSizingMethod;

    private CreateLaunchConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.ec2LaunchTemplateID = builder.ec2LaunchTemplateID;
        this.enableMapAutoTagging = builder.enableMapAutoTagging;
        this.largeVolumeConf = builder.largeVolumeConf;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.mapAutoTaggingMpeID = builder.mapAutoTaggingMpeID;
        this.postLaunchActions = builder.postLaunchActions;
        this.smallVolumeConf = builder.smallVolumeConf;
        this.smallVolumeMaxSize = builder.smallVolumeMaxSize;
        this.tags = builder.tags;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * ARN of the Launch Configuration Template.
     * </p>
     * 
     * @return ARN of the Launch Configuration Template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Associate public Ip address.
     * </p>
     * 
     * @return Associate public Ip address.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Launch configuration template boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration template boot mode.
     * @see BootMode
     */
    public final BootMode bootMode() {
        return BootMode.fromValue(bootMode);
    }

    /**
     * <p>
     * Launch configuration template boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration template boot mode.
     * @see BootMode
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * Copy private Ip.
     * </p>
     * 
     * @return Copy private Ip.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Copy tags.
     * </p>
     * 
     * @return Copy tags.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * EC2 launch template ID.
     * </p>
     * 
     * @return EC2 launch template ID.
     */
    public final String ec2LaunchTemplateID() {
        return ec2LaunchTemplateID;
    }

    /**
     * <p>
     * Enable map auto tagging.
     * </p>
     * 
     * @return Enable map auto tagging.
     */
    public final Boolean enableMapAutoTagging() {
        return enableMapAutoTagging;
    }

    /**
     * <p>
     * Large volume config.
     * </p>
     * 
     * @return Large volume config.
     */
    public final LaunchTemplateDiskConf largeVolumeConf() {
        return largeVolumeConf;
    }

    /**
     * <p>
     * ID of the Launch Configuration Template.
     * </p>
     * 
     * @return ID of the Launch Configuration Template.
     */
    public final String launchConfigurationTemplateID() {
        return launchConfigurationTemplateID;
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * Returns the value of the Licensing property for this object.
     * 
     * @return The value of the Licensing property for this object.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * Launch configuration template map auto tagging MPE ID.
     * </p>
     * 
     * @return Launch configuration template map auto tagging MPE ID.
     */
    public final String mapAutoTaggingMpeID() {
        return mapAutoTaggingMpeID;
    }

    /**
     * <p>
     * Post Launch Actions of the Launch Configuration Template.
     * </p>
     * 
     * @return Post Launch Actions of the Launch Configuration Template.
     */
    public final PostLaunchActions postLaunchActions() {
        return postLaunchActions;
    }

    /**
     * <p>
     * Small volume config.
     * </p>
     * 
     * @return Small volume config.
     */
    public final LaunchTemplateDiskConf smallVolumeConf() {
        return smallVolumeConf;
    }

    /**
     * <p>
     * Small volume maximum size.
     * </p>
     * 
     * @return Small volume maximum size.
     */
    public final Long smallVolumeMaxSize() {
        return smallVolumeMaxSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags of the Launch Configuration Template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags of the Launch Configuration Template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(ec2LaunchTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(enableMapAutoTagging());
        hashCode = 31 * hashCode + Objects.hashCode(largeVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(mapAutoTaggingMpeID());
        hashCode = 31 * hashCode + Objects.hashCode(postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(smallVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(smallVolumeMaxSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationTemplateResponse)) {
            return false;
        }
        CreateLaunchConfigurationTemplateResponse other = (CreateLaunchConfigurationTemplateResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(ec2LaunchTemplateID(), other.ec2LaunchTemplateID())
                && Objects.equals(enableMapAutoTagging(), other.enableMapAutoTagging())
                && Objects.equals(largeVolumeConf(), other.largeVolumeConf())
                && Objects.equals(launchConfigurationTemplateID(), other.launchConfigurationTemplateID())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(mapAutoTaggingMpeID(), other.mapAutoTaggingMpeID())
                && Objects.equals(postLaunchActions(), other.postLaunchActions())
                && Objects.equals(smallVolumeConf(), other.smallVolumeConf())
                && Objects.equals(smallVolumeMaxSize(), other.smallVolumeMaxSize())
                && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLaunchConfigurationTemplateResponse").add("Arn", arn())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("BootMode", bootModeAsString())
                .add("CopyPrivateIp", copyPrivateIp()).add("CopyTags", copyTags())
                .add("Ec2LaunchTemplateID", ec2LaunchTemplateID()).add("EnableMapAutoTagging", enableMapAutoTagging())
                .add("LargeVolumeConf", largeVolumeConf()).add("LaunchConfigurationTemplateID", launchConfigurationTemplateID())
                .add("LaunchDisposition", launchDispositionAsString()).add("Licensing", licensing())
                .add("MapAutoTaggingMpeID", mapAutoTaggingMpeID()).add("PostLaunchActions", postLaunchActions())
                .add("SmallVolumeConf", smallVolumeConf()).add("SmallVolumeMaxSize", smallVolumeMaxSize())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "associatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "bootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "ec2LaunchTemplateID":
            return Optional.ofNullable(clazz.cast(ec2LaunchTemplateID()));
        case "enableMapAutoTagging":
            return Optional.ofNullable(clazz.cast(enableMapAutoTagging()));
        case "largeVolumeConf":
            return Optional.ofNullable(clazz.cast(largeVolumeConf()));
        case "launchConfigurationTemplateID":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplateID()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "mapAutoTaggingMpeID":
            return Optional.ofNullable(clazz.cast(mapAutoTaggingMpeID()));
        case "postLaunchActions":
            return Optional.ofNullable(clazz.cast(postLaunchActions()));
        case "smallVolumeConf":
            return Optional.ofNullable(clazz.cast(smallVolumeConf()));
        case "smallVolumeMaxSize":
            return Optional.ofNullable(clazz.cast(smallVolumeMaxSize()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLaunchConfigurationTemplateResponse> {
        /**
         * <p>
         * ARN of the Launch Configuration Template.
         * </p>
         * 
         * @param arn
         *        ARN of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Associate public Ip address.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associate public Ip address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Launch configuration template boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration template boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * Launch configuration template boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration template boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(BootMode bootMode);

        /**
         * <p>
         * Copy private Ip.
         * </p>
         * 
         * @param copyPrivateIp
         *        Copy private Ip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Copy tags.
         * </p>
         * 
         * @param copyTags
         *        Copy tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * EC2 launch template ID.
         * </p>
         * 
         * @param ec2LaunchTemplateID
         *        EC2 launch template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2LaunchTemplateID(String ec2LaunchTemplateID);

        /**
         * <p>
         * Enable map auto tagging.
         * </p>
         * 
         * @param enableMapAutoTagging
         *        Enable map auto tagging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMapAutoTagging(Boolean enableMapAutoTagging);

        /**
         * <p>
         * Large volume config.
         * </p>
         * 
         * @param largeVolumeConf
         *        Large volume config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf);

        /**
         * <p>
         * Large volume config.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateDiskConf.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateDiskConf#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateDiskConf.Builder#build()} is called immediately and
         * its result is passed to {@link #largeVolumeConf(LaunchTemplateDiskConf)}.
         * 
         * @param largeVolumeConf
         *        a consumer that will call methods on {@link LaunchTemplateDiskConf.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #largeVolumeConf(LaunchTemplateDiskConf)
         */
        default Builder largeVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> largeVolumeConf) {
            return largeVolumeConf(LaunchTemplateDiskConf.builder().applyMutation(largeVolumeConf).build());
        }

        /**
         * <p>
         * ID of the Launch Configuration Template.
         * </p>
         * 
         * @param launchConfigurationTemplateID
         *        ID of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplateID(String launchConfigurationTemplateID);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * Sets the value of the Licensing property for this object.
         *
         * @param licensing
         *        The new value for the Licensing property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * Sets the value of the Licensing property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * Launch configuration template map auto tagging MPE ID.
         * </p>
         * 
         * @param mapAutoTaggingMpeID
         *        Launch configuration template map auto tagging MPE ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID);

        /**
         * <p>
         * Post Launch Actions of the Launch Configuration Template.
         * </p>
         * 
         * @param postLaunchActions
         *        Post Launch Actions of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActions(PostLaunchActions postLaunchActions);

        /**
         * <p>
         * Post Launch Actions of the Launch Configuration Template.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostLaunchActions.Builder} avoiding the
         * need to create one manually via {@link PostLaunchActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostLaunchActions.Builder#build()} is called immediately and its
         * result is passed to {@link #postLaunchActions(PostLaunchActions)}.
         * 
         * @param postLaunchActions
         *        a consumer that will call methods on {@link PostLaunchActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postLaunchActions(PostLaunchActions)
         */
        default Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return postLaunchActions(PostLaunchActions.builder().applyMutation(postLaunchActions).build());
        }

        /**
         * <p>
         * Small volume config.
         * </p>
         * 
         * @param smallVolumeConf
         *        Small volume config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf);

        /**
         * <p>
         * Small volume config.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateDiskConf.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateDiskConf#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateDiskConf.Builder#build()} is called immediately and
         * its result is passed to {@link #smallVolumeConf(LaunchTemplateDiskConf)}.
         * 
         * @param smallVolumeConf
         *        a consumer that will call methods on {@link LaunchTemplateDiskConf.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallVolumeConf(LaunchTemplateDiskConf)
         */
        default Builder smallVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> smallVolumeConf) {
            return smallVolumeConf(LaunchTemplateDiskConf.builder().applyMutation(smallVolumeConf).build());
        }

        /**
         * <p>
         * Small volume maximum size.
         * </p>
         * 
         * @param smallVolumeMaxSize
         *        Small volume maximum size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallVolumeMaxSize(Long smallVolumeMaxSize);

        /**
         * <p>
         * Tags of the Launch Configuration Template.
         * </p>
         * 
         * @param tags
         *        Tags of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private String arn;

        private Boolean associatePublicIpAddress;

        private String bootMode;

        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private String ec2LaunchTemplateID;

        private Boolean enableMapAutoTagging;

        private LaunchTemplateDiskConf largeVolumeConf;

        private String launchConfigurationTemplateID;

        private String launchDisposition;

        private Licensing licensing;

        private String mapAutoTaggingMpeID;

        private PostLaunchActions postLaunchActions;

        private LaunchTemplateDiskConf smallVolumeConf;

        private Long smallVolumeMaxSize;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationTemplateResponse model) {
            super(model);
            arn(model.arn);
            associatePublicIpAddress(model.associatePublicIpAddress);
            bootMode(model.bootMode);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            ec2LaunchTemplateID(model.ec2LaunchTemplateID);
            enableMapAutoTagging(model.enableMapAutoTagging);
            largeVolumeConf(model.largeVolumeConf);
            launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            mapAutoTaggingMpeID(model.mapAutoTaggingMpeID);
            postLaunchActions(model.postLaunchActions);
            smallVolumeConf(model.smallVolumeConf);
            smallVolumeMaxSize(model.smallVolumeMaxSize);
            tags(model.tags);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getEc2LaunchTemplateID() {
            return ec2LaunchTemplateID;
        }

        public final void setEc2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
        }

        @Override
        public final Builder ec2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
            return this;
        }

        public final Boolean getEnableMapAutoTagging() {
            return enableMapAutoTagging;
        }

        public final void setEnableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
        }

        @Override
        public final Builder enableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getLargeVolumeConf() {
            return largeVolumeConf != null ? largeVolumeConf.toBuilder() : null;
        }

        public final void setLargeVolumeConf(LaunchTemplateDiskConf.BuilderImpl largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf != null ? largeVolumeConf.build() : null;
        }

        @Override
        public final Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getMapAutoTaggingMpeID() {
            return mapAutoTaggingMpeID;
        }

        public final void setMapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
        }

        @Override
        public final Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return postLaunchActions != null ? postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getSmallVolumeConf() {
            return smallVolumeConf != null ? smallVolumeConf.toBuilder() : null;
        }

        public final void setSmallVolumeConf(LaunchTemplateDiskConf.BuilderImpl smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf != null ? smallVolumeConf.build() : null;
        }

        @Override
        public final Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf;
            return this;
        }

        public final Long getSmallVolumeMaxSize() {
            return smallVolumeMaxSize;
        }

        public final void setSmallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
        }

        @Override
        public final Builder smallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public CreateLaunchConfigurationTemplateResponse build() {
            return new CreateLaunchConfigurationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
