/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ImportTaskError;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;

public class ListImportErrorsIterable
implements SdkIterable<ListImportErrorsResponse> {
    private final MgnClient client;
    private final ListImportErrorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportErrorsIterable(MgnClient client, ListImportErrorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportErrorsResponseFetcher();
    }

    public Iterator<ListImportErrorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportTaskError> items() {
        Function<ListImportErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportErrorsResponseFetcher
    implements SyncPageFetcher<ListImportErrorsResponse> {
        private ListImportErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportErrorsResponse nextPage(ListImportErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListImportErrorsIterable.this.client.listImportErrors(ListImportErrorsIterable.this.firstRequest);
            }
            return ListImportErrorsIterable.this.client.listImportErrors((ListImportErrorsRequest)((Object)ListImportErrorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

