/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mgn.DefaultMgnBaseClientBuilder;
import software.amazon.awssdk.services.mgn.DefaultMgnClient;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.MgnClientBuilder;
import software.amazon.awssdk.services.mgn.MgnServiceClientConfiguration;
import software.amazon.awssdk.services.mgn.endpoints.MgnEndpointProvider;

@SdkInternalApi
final class DefaultMgnClientBuilder
extends DefaultMgnBaseClientBuilder<MgnClientBuilder, MgnClient>
implements MgnClientBuilder {
    DefaultMgnClientBuilder() {
    }

    @Override
    public DefaultMgnClientBuilder endpointProvider(MgnEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MgnClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMgnClientBuilder.validateClientOptions(clientConfiguration);
        MgnServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMgnClient client = new DefaultMgnClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MgnServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MgnServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

