/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An update that you can apply to your MemoryDB clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceUpdate implements SdkPojo, Serializable, ToCopyableBuilder<ServiceUpdate.Builder, ServiceUpdate> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(ServiceUpdate::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(ServiceUpdate::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReleaseDate").getter(getter(ServiceUpdate::releaseDate)).setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ServiceUpdate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServiceUpdate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ServiceUpdate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NODES_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodesUpdated").getter(getter(ServiceUpdate::nodesUpdated)).setter(setter(Builder::nodesUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodesUpdated").build()).build();

    private static final SdkField<Instant> AUTO_UPDATE_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AutoUpdateStartDate").getter(getter(ServiceUpdate::autoUpdateStartDate))
            .setter(setter(Builder::autoUpdateStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdateStartDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            SERVICE_UPDATE_NAME_FIELD, RELEASE_DATE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TYPE_FIELD, NODES_UPDATED_FIELD,
            AUTO_UPDATE_START_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String serviceUpdateName;

    private final Instant releaseDate;

    private final String description;

    private final String status;

    private final String type;

    private final String nodesUpdated;

    private final Instant autoUpdateStartDate;

    private ServiceUpdate(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.releaseDate = builder.releaseDate;
        this.description = builder.description;
        this.status = builder.status;
        this.type = builder.type;
        this.nodesUpdated = builder.nodesUpdated;
        this.autoUpdateStartDate = builder.autoUpdateStartDate;
    }

    /**
     * <p>
     * The name of the cluster to which the service update applies
     * </p>
     * 
     * @return The name of the cluster to which the service update applies
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * <p>
     * The date when the service update is initially available
     * </p>
     * 
     * @return The date when the service update is initially available
     */
    public final Instant releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * Provides details of the service update
     * </p>
     * 
     * @return Provides details of the service update
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public final ServiceUpdateStatus status() {
        return ServiceUpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Reflects the nature of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServiceUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Reflects the nature of the service update
     * @see ServiceUpdateType
     */
    public final ServiceUpdateType type() {
        return ServiceUpdateType.fromValue(type);
    }

    /**
     * <p>
     * Reflects the nature of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServiceUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Reflects the nature of the service update
     * @see ServiceUpdateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of nodes updated by the service update
     * </p>
     * 
     * @return A list of nodes updated by the service update
     */
    public final String nodesUpdated() {
        return nodesUpdated;
    }

    /**
     * <p>
     * The date at which the service update will be automatically applied
     * </p>
     * 
     * @return The date at which the service update will be automatically applied
     */
    public final Instant autoUpdateStartDate() {
        return autoUpdateStartDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateStartDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceUpdate)) {
            return false;
        }
        ServiceUpdate other = (ServiceUpdate) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && Objects.equals(releaseDate(), other.releaseDate()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(nodesUpdated(), other.nodesUpdated())
                && Objects.equals(autoUpdateStartDate(), other.autoUpdateStartDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceUpdate").add("ClusterName", clusterName()).add("ServiceUpdateName", serviceUpdateName())
                .add("ReleaseDate", releaseDate()).add("Description", description()).add("Status", statusAsString())
                .add("Type", typeAsString()).add("NodesUpdated", nodesUpdated())
                .add("AutoUpdateStartDate", autoUpdateStartDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NodesUpdated":
            return Optional.ofNullable(clazz.cast(nodesUpdated()));
        case "AutoUpdateStartDate":
            return Optional.ofNullable(clazz.cast(autoUpdateStartDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceUpdate, T> g) {
        return obj -> g.apply((ServiceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceUpdate> {
        /**
         * <p>
         * The name of the cluster to which the service update applies
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to which the service update applies
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The date when the service update is initially available
         * </p>
         * 
         * @param releaseDate
         *        The date when the service update is initially available
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(Instant releaseDate);

        /**
         * <p>
         * Provides details of the service update
         * </p>
         * 
         * @param description
         *        Provides details of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param status
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param status
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder status(ServiceUpdateStatus status);

        /**
         * <p>
         * Reflects the nature of the service update
         * </p>
         * 
         * @param type
         *        Reflects the nature of the service update
         * @see ServiceUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateType
         */
        Builder type(String type);

        /**
         * <p>
         * Reflects the nature of the service update
         * </p>
         * 
         * @param type
         *        Reflects the nature of the service update
         * @see ServiceUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateType
         */
        Builder type(ServiceUpdateType type);

        /**
         * <p>
         * A list of nodes updated by the service update
         * </p>
         * 
         * @param nodesUpdated
         *        A list of nodes updated by the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesUpdated(String nodesUpdated);

        /**
         * <p>
         * The date at which the service update will be automatically applied
         * </p>
         * 
         * @param autoUpdateStartDate
         *        The date at which the service update will be automatically applied
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdateStartDate(Instant autoUpdateStartDate);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private String serviceUpdateName;

        private Instant releaseDate;

        private String description;

        private String status;

        private String type;

        private String nodesUpdated;

        private Instant autoUpdateStartDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUpdate model) {
            clusterName(model.clusterName);
            serviceUpdateName(model.serviceUpdateName);
            releaseDate(model.releaseDate);
            description(model.description);
            status(model.status);
            type(model.type);
            nodesUpdated(model.nodesUpdated);
            autoUpdateStartDate(model.autoUpdateStartDate);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final Instant getReleaseDate() {
            return releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceUpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServiceUpdateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNodesUpdated() {
            return nodesUpdated;
        }

        public final void setNodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
        }

        @Override
        public final Builder nodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
            return this;
        }

        public final Instant getAutoUpdateStartDate() {
            return autoUpdateStartDate;
        }

        public final void setAutoUpdateStartDate(Instant autoUpdateStartDate) {
            this.autoUpdateStartDate = autoUpdateStartDate;
        }

        @Override
        public final Builder autoUpdateStartDate(Instant autoUpdateStartDate) {
            this.autoUpdateStartDate = autoUpdateStartDate;
            return this;
        }

        @Override
        public ServiceUpdate build() {
            return new ServiceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
