/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorBaseClientBuilder;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClientBuilder;
import software.amazon.awssdk.services.mediatailor.MediaTailorServiceClientConfiguration;
import software.amazon.awssdk.services.mediatailor.endpoints.MediaTailorEndpointProvider;

@SdkInternalApi
final class DefaultMediaTailorAsyncClientBuilder
extends DefaultMediaTailorBaseClientBuilder<MediaTailorAsyncClientBuilder, MediaTailorAsyncClient>
implements MediaTailorAsyncClientBuilder {
    DefaultMediaTailorAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaTailorAsyncClientBuilder endpointProvider(MediaTailorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaTailorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaTailorAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaTailorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaTailorAsyncClient client = new DefaultMediaTailorAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaTailorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaTailorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

