/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures Amazon CloudWatch log settings for a playback configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsForPlaybackConfigurationRequest extends MediaTailorRequest implements
        ToCopyableBuilder<ConfigureLogsForPlaybackConfigurationRequest.Builder, ConfigureLogsForPlaybackConfigurationRequest> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentEnabled").getter(getter(ConfigureLogsForPlaybackConfigurationRequest::percentEnabled))
            .setter(setter(Builder::percentEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName")
            .getter(getter(ConfigureLogsForPlaybackConfigurationRequest::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD,
            PLAYBACK_CONFIGURATION_NAME_FIELD));

    private final Integer percentEnabled;

    private final String playbackConfigurationName;

    private ConfigureLogsForPlaybackConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.percentEnabled = builder.percentEnabled;
        this.playbackConfigurationName = builder.playbackConfigurationName;
    }

    /**
     * <p>
     * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your
     * playback configuration has 1000 sessions and percentEnabled is set to <code>60</code>, MediaTailor sends logs for
     * 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration
     * sessions to send logs for. If you want to view logs for a specific session, you can use the <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.
     * </p>
     * <p>
     * Valid values: <code>0</code> - <code>100</code>
     * </p>
     * 
     * @return The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if
     *         your playback configuration has 1000 sessions and percentEnabled is set to <code>60</code>, MediaTailor
     *         sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the
     *         playback configuration sessions to send logs for. If you want to view logs for a specific session, you
     *         can use the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log
     *         mode</a>.</p>
     *         <p>
     *         Valid values: <code>0</code> - <code>100</code>
     */
    public final Integer percentEnabled() {
        return percentEnabled;
    }

    /**
     * <p>
     * The name of the playback configuration.
     * </p>
     * 
     * @return The name of the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForPlaybackConfigurationRequest)) {
            return false;
        }
        ConfigureLogsForPlaybackConfigurationRequest other = (ConfigureLogsForPlaybackConfigurationRequest) obj;
        return Objects.equals(percentEnabled(), other.percentEnabled())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsForPlaybackConfigurationRequest").add("PercentEnabled", percentEnabled())
                .add("PlaybackConfigurationName", playbackConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentEnabled":
            return Optional.ofNullable(clazz.cast(percentEnabled()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForPlaybackConfigurationRequest, T> g) {
        return obj -> g.apply((ConfigureLogsForPlaybackConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationRequest> {
        /**
         * <p>
         * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your
         * playback configuration has 1000 sessions and percentEnabled is set to <code>60</code>, MediaTailor sends logs
         * for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration
         * sessions to send logs for. If you want to view logs for a specific session, you can use the <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.
         * </p>
         * <p>
         * Valid values: <code>0</code> - <code>100</code>
         * </p>
         * 
         * @param percentEnabled
         *        The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if
         *        your playback configuration has 1000 sessions and percentEnabled is set to <code>60</code>,
         *        MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which
         *        of the playback configuration sessions to send logs for. If you want to view logs for a specific
         *        session, you can use the <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.</p>
         *        <p>
         *        Valid values: <code>0</code> - <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentEnabled(Integer percentEnabled);

        /**
         * <p>
         * The name of the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name of the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private Integer percentEnabled;

        private String playbackConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForPlaybackConfigurationRequest model) {
            super(model);
            percentEnabled(model.percentEnabled);
            playbackConfigurationName(model.playbackConfigurationName);
        }

        public final Integer getPercentEnabled() {
            return percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsForPlaybackConfigurationRequest build() {
            return new ConfigureLogsForPlaybackConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
