/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Schedule configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramScheduleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProgramScheduleConfiguration.Builder, UpdateProgramScheduleConfiguration> {
    private static final SdkField<ClipRange> CLIP_RANGE_FIELD = SdkField.<ClipRange> builder(MarshallingType.SDK_POJO)
            .memberName("ClipRange").getter(getter(UpdateProgramScheduleConfiguration::clipRange))
            .setter(setter(Builder::clipRange)).constructor(ClipRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipRange").build()).build();

    private static final SdkField<UpdateProgramTransition> TRANSITION_FIELD = SdkField
            .<UpdateProgramTransition> builder(MarshallingType.SDK_POJO).memberName("Transition")
            .getter(getter(UpdateProgramScheduleConfiguration::transition)).setter(setter(Builder::transition))
            .constructor(UpdateProgramTransition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIP_RANGE_FIELD,
            TRANSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ClipRange clipRange;

    private final UpdateProgramTransition transition;

    private UpdateProgramScheduleConfiguration(BuilderImpl builder) {
        this.clipRange = builder.clipRange;
        this.transition = builder.transition;
    }

    /**
     * <p>
     * Program clip range configuration.
     * </p>
     * 
     * @return Program clip range configuration.
     */
    public final ClipRange clipRange() {
        return clipRange;
    }

    /**
     * <p>
     * Program transition configuration.
     * </p>
     * 
     * @return Program transition configuration.
     */
    public final UpdateProgramTransition transition() {
        return transition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clipRange());
        hashCode = 31 * hashCode + Objects.hashCode(transition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramScheduleConfiguration)) {
            return false;
        }
        UpdateProgramScheduleConfiguration other = (UpdateProgramScheduleConfiguration) obj;
        return Objects.equals(clipRange(), other.clipRange()) && Objects.equals(transition(), other.transition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramScheduleConfiguration").add("ClipRange", clipRange())
                .add("Transition", transition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClipRange":
            return Optional.ofNullable(clazz.cast(clipRange()));
        case "Transition":
            return Optional.ofNullable(clazz.cast(transition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramScheduleConfiguration, T> g) {
        return obj -> g.apply((UpdateProgramScheduleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProgramScheduleConfiguration> {
        /**
         * <p>
         * Program clip range configuration.
         * </p>
         * 
         * @param clipRange
         *        Program clip range configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clipRange(ClipRange clipRange);

        /**
         * <p>
         * Program clip range configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClipRange.Builder} avoiding the need to
         * create one manually via {@link ClipRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClipRange.Builder#build()} is called immediately and its result
         * is passed to {@link #clipRange(ClipRange)}.
         * 
         * @param clipRange
         *        a consumer that will call methods on {@link ClipRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clipRange(ClipRange)
         */
        default Builder clipRange(Consumer<ClipRange.Builder> clipRange) {
            return clipRange(ClipRange.builder().applyMutation(clipRange).build());
        }

        /**
         * <p>
         * Program transition configuration.
         * </p>
         * 
         * @param transition
         *        Program transition configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transition(UpdateProgramTransition transition);

        /**
         * <p>
         * Program transition configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateProgramTransition.Builder} avoiding
         * the need to create one manually via {@link UpdateProgramTransition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateProgramTransition.Builder#build()} is called immediately
         * and its result is passed to {@link #transition(UpdateProgramTransition)}.
         * 
         * @param transition
         *        a consumer that will call methods on {@link UpdateProgramTransition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transition(UpdateProgramTransition)
         */
        default Builder transition(Consumer<UpdateProgramTransition.Builder> transition) {
            return transition(UpdateProgramTransition.builder().applyMutation(transition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClipRange clipRange;

        private UpdateProgramTransition transition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramScheduleConfiguration model) {
            clipRange(model.clipRange);
            transition(model.transition);
        }

        public final ClipRange.Builder getClipRange() {
            return clipRange != null ? clipRange.toBuilder() : null;
        }

        public final void setClipRange(ClipRange.BuilderImpl clipRange) {
            this.clipRange = clipRange != null ? clipRange.build() : null;
        }

        @Override
        public final Builder clipRange(ClipRange clipRange) {
            this.clipRange = clipRange;
            return this;
        }

        public final UpdateProgramTransition.Builder getTransition() {
            return transition != null ? transition.toBuilder() : null;
        }

        public final void setTransition(UpdateProgramTransition.BuilderImpl transition) {
            this.transition = transition != null ? transition.build() : null;
        }

        @Override
        public final Builder transition(UpdateProgramTransition transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public UpdateProgramScheduleConfiguration build() {
            return new UpdateProgramScheduleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
