/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.RequestOutputItem;
import software.amazon.awssdk.services.mediatailor.model.RequestOutputsCopier;
import software.amazon.awssdk.services.mediatailor.model.SlateSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, UpdateChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(UpdateChannelRequest.getter(UpdateChannelRequest::channelName)).setter(UpdateChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()}).build();
    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FillerSlate").getter(UpdateChannelRequest.getter(UpdateChannelRequest::fillerSlate)).setter(UpdateChannelRequest.setter(Builder::fillerSlate)).constructor(SlateSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()}).build();
    private static final SdkField<List<RequestOutputItem>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(UpdateChannelRequest.getter(UpdateChannelRequest::outputs)).setter(UpdateChannelRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, FILLER_SLATE_FIELD, OUTPUTS_FIELD));
    private final String channelName;
    private final SlateSource fillerSlate;
    private final List<RequestOutputItem> outputs;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.fillerSlate = builder.fillerSlate;
        this.outputs = builder.outputs;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final SlateSource fillerSlate() {
        return this.fillerSlate;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<RequestOutputItem> outputs() {
        return this.outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.fillerSlate(), other.fillerSlate()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelRequest").add("ChannelName", (Object)this.channelName()).add("FillerSlate", (Object)this.fillerSlate()).add("Outputs", this.hasOutputs() ? this.outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "FillerSlate": {
                return Optional.ofNullable(clazz.cast(this.fillerSlate()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String channelName;
        private SlateSource fillerSlate;
        private List<RequestOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            this.channelName(model.channelName);
            this.fillerSlate(model.fillerSlate);
            this.outputs(model.outputs);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return this.fillerSlate != null ? this.fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final List<RequestOutputItem.Builder> getOutputs() {
            List<RequestOutputItem.Builder> result = RequestOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RequestOutputItem.BuilderImpl> outputs) {
            this.outputs = RequestOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RequestOutputItem> outputs) {
            this.outputs = RequestOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RequestOutputItem ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RequestOutputItem.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (RequestOutputItem)((RequestOutputItem.Builder)RequestOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelRequest> {
        public Builder channelName(String var1);

        public Builder fillerSlate(SlateSource var1);

        default public Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return this.fillerSlate((SlateSource)((SlateSource.Builder)SlateSource.builder().applyMutation(fillerSlate)).build());
        }

        public Builder outputs(Collection<RequestOutputItem> var1);

        public Builder outputs(RequestOutputItem ... var1);

        public Builder outputs(Consumer<RequestOutputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

