/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelativePosition {
    BEFORE_PROGRAM("BEFORE_PROGRAM"),
    AFTER_PROGRAM("AFTER_PROGRAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelativePosition> VALUE_MAP;
    private final String value;

    private RelativePosition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelativePosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelativePosition> knownValues() {
        EnumSet<RelativePosition> knownValues = EnumSet.allOf(RelativePosition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelativePosition.class, RelativePosition::toString);
    }
}

