/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLowLatencyHlsManifestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GetLowLatencyHlsManifestConfiguration.Builder, GetLowLatencyHlsManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(GetLowLatencyHlsManifestConfiguration::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(GetLowLatencyHlsManifestConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> CHILD_MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChildManifestName").getter(getter(GetLowLatencyHlsManifestConfiguration::childManifestName))
            .setter(setter(Builder::childManifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildManifestName").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(GetLowLatencyHlsManifestConfiguration::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramDateTimeIntervalSeconds")
            .getter(getter(GetLowLatencyHlsManifestConfiguration::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramDateTimeIntervalSeconds")
                    .build()).build();

    private static final SdkField<ScteHls> SCTE_HLS_FIELD = SdkField.<ScteHls> builder(MarshallingType.SDK_POJO)
            .memberName("ScteHls").getter(getter(GetLowLatencyHlsManifestConfiguration::scteHls))
            .setter(setter(Builder::scteHls)).constructor(ScteHls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteHls").build()).build();

    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField
            .<FilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("FilterConfiguration")
            .getter(getter(GetLowLatencyHlsManifestConfiguration::filterConfiguration))
            .setter(setter(Builder::filterConfiguration)).constructor(FilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD,
            URL_FIELD, CHILD_MANIFEST_NAME_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD,
            SCTE_HLS_FIELD, FILTER_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestName;

    private final String url;

    private final String childManifestName;

    private final Integer manifestWindowSeconds;

    private final Integer programDateTimeIntervalSeconds;

    private final ScteHls scteHls;

    private final FilterConfiguration filterConfiguration;

    private GetLowLatencyHlsManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.url = builder.url;
        this.childManifestName = builder.childManifestName;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.scteHls = builder.scteHls;
        this.filterConfiguration = builder.filterConfiguration;
    }

    /**
     * <p>
     * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS
     * manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you
     * provided on the originEndpoint object.
     * </p>
     * 
     * @return A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     *         automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you
     *         use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
     *         manifestName you provided on the originEndpoint object.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * The egress domain URL for stream delivery from MediaPackage.
     * </p>
     * 
     * @return The egress domain URL for stream delivery from MediaPackage.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
     * manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
     * </p>
     * 
     * @return A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
     *         manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint
     *         object.
     */
    public final String childManifestName() {
        return childManifestName;
    }

    /**
     * <p>
     * The total duration (in seconds) of the manifest's content.
     * </p>
     * 
     * @return The total duration (in seconds) of the manifest's content.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * <p>
     * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter
     * an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to the wall
     * clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata
     * messages generate every 5 seconds whenever the content is ingested.
     * </p>
     * <p>
     * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS
     * output.
     * </p>
     * 
     * @return Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you
     *         don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the
     *         stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the
     *         player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
     *         <p>
     *         Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the
     *         HLS output.
     */
    public final Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    /**
     * Returns the value of the ScteHls property for this object.
     * 
     * @return The value of the ScteHls property for this object.
     */
    public final ScteHls scteHls() {
        return scteHls;
    }

    /**
     * Returns the value of the FilterConfiguration property for this object.
     * 
     * @return The value of the FilterConfiguration property for this object.
     */
    public final FilterConfiguration filterConfiguration() {
        return filterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(childManifestName());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(scteHls());
        hashCode = 31 * hashCode + Objects.hashCode(filterConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLowLatencyHlsManifestConfiguration)) {
            return false;
        }
        GetLowLatencyHlsManifestConfiguration other = (GetLowLatencyHlsManifestConfiguration) obj;
        return Objects.equals(manifestName(), other.manifestName()) && Objects.equals(url(), other.url())
                && Objects.equals(childManifestName(), other.childManifestName())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds())
                && Objects.equals(scteHls(), other.scteHls())
                && Objects.equals(filterConfiguration(), other.filterConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLowLatencyHlsManifestConfiguration").add("ManifestName", manifestName()).add("Url", url())
                .add("ChildManifestName", childManifestName()).add("ManifestWindowSeconds", manifestWindowSeconds())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds()).add("ScteHls", scteHls())
                .add("FilterConfiguration", filterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ChildManifestName":
            return Optional.ofNullable(clazz.cast(childManifestName()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        case "ScteHls":
            return Optional.ofNullable(clazz.cast(scteHls()));
        case "FilterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLowLatencyHlsManifestConfiguration, T> g) {
        return obj -> g.apply((GetLowLatencyHlsManifestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetLowLatencyHlsManifestConfiguration> {
        /**
         * <p>
         * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
         * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use
         * HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
         * manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param manifestName
         *        A short short string that's appended to the endpoint URL. The manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
         *        MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same
         *        manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the
         *        HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * The egress domain URL for stream delivery from MediaPackage.
         * </p>
         * 
         * @param url
         *        The egress domain URL for stream delivery from MediaPackage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
         * manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param childManifestName
         *        A short string that's appended to the endpoint URL. The child manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1.
         *        The manifestName on the HLSManifest object overrides the manifestName you provided on the
         *        originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childManifestName(String childManifestName);

        /**
         * <p>
         * The total duration (in seconds) of the manifest's content.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of the manifest's content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * <p>
         * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't
         * enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to
         * the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed
         * metadata messages generate every 5 seconds whenever the content is ingested.
         * </p>
         * <p>
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS
         * output.
         * </p>
         * 
         * @param programDateTimeIntervalSeconds
         *        Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you
         *        don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync
         *        the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on
         *        the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
         *        <p>
         *        Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to
         *        the HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);

        /**
         * Sets the value of the ScteHls property for this object.
         *
         * @param scteHls
         *        The new value for the ScteHls property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteHls(ScteHls scteHls);

        /**
         * Sets the value of the ScteHls property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScteHls.Builder} avoiding the need to
         * create one manually via {@link ScteHls#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScteHls.Builder#build()} is called immediately and its result is
         * passed to {@link #scteHls(ScteHls)}.
         * 
         * @param scteHls
         *        a consumer that will call methods on {@link ScteHls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scteHls(ScteHls)
         */
        default Builder scteHls(Consumer<ScteHls.Builder> scteHls) {
            return scteHls(ScteHls.builder().applyMutation(scteHls).build());
        }

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * @param filterConfiguration
         *        The new value for the FilterConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(FilterConfiguration filterConfiguration);

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FilterConfiguration.Builder} avoiding the
         * need to create one manually via {@link FilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #filterConfiguration(FilterConfiguration)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on {@link FilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(FilterConfiguration)
         */
        default Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return filterConfiguration(FilterConfiguration.builder().applyMutation(filterConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String manifestName;

        private String url;

        private String childManifestName;

        private Integer manifestWindowSeconds;

        private Integer programDateTimeIntervalSeconds;

        private ScteHls scteHls;

        private FilterConfiguration filterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLowLatencyHlsManifestConfiguration model) {
            manifestName(model.manifestName);
            url(model.url);
            childManifestName(model.childManifestName);
            manifestWindowSeconds(model.manifestWindowSeconds);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            scteHls(model.scteHls);
            filterConfiguration(model.filterConfiguration);
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getChildManifestName() {
            return childManifestName;
        }

        public final void setChildManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
        }

        @Override
        public final Builder childManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final ScteHls.Builder getScteHls() {
            return scteHls != null ? scteHls.toBuilder() : null;
        }

        public final void setScteHls(ScteHls.BuilderImpl scteHls) {
            this.scteHls = scteHls != null ? scteHls.build() : null;
        }

        @Override
        public final Builder scteHls(ScteHls scteHls) {
            this.scteHls = scteHls;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return filterConfiguration != null ? filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        @Override
        public GetLowLatencyHlsManifestConfiguration build() {
            return new GetLowLatencyHlsManifestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
