/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all
 * of your egress requests for this manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterConfiguration.Builder, FilterConfiguration> {
    private static final SdkField<String> MANIFEST_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestFilter").getter(getter(FilterConfiguration::manifestFilter))
            .setter(setter(Builder::manifestFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFilter").build()).build();

    private static final SdkField<Instant> START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Start")
            .getter(getter(FilterConfiguration::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("End")
            .getter(getter(FilterConfiguration::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<Integer> TIME_DELAY_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeDelaySeconds").getter(getter(FilterConfiguration::timeDelaySeconds))
            .setter(setter(Builder::timeDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeDelaySeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FILTER_FIELD,
            START_FIELD, END_FIELD, TIME_DELAY_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestFilter;

    private final Instant start;

    private final Instant end;

    private final Integer timeDelaySeconds;

    private FilterConfiguration(BuilderImpl builder) {
        this.manifestFilter = builder.manifestFilter;
        this.start = builder.start;
        this.end = builder.end;
        this.timeDelaySeconds = builder.timeDelaySeconds;
    }

    /**
     * <p>
     * Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a
     * manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's
     * endpoint URL.
     * </p>
     * 
     * @return Optionally specify one or more manifest filters for all of your manifest egress requests. When you
     *         include a manifest filter, note that you cannot use an identical manifest filter query parameter for this
     *         manifest's endpoint URL.
     */
    public final String manifestFilter() {
        return manifestFilter;
    }

    /**
     * <p>
     * Optionally specify the start time for all of your manifest egress requests. When you include start time, note
     * that you cannot use start time query parameters for this manifest's endpoint URL.
     * </p>
     * 
     * @return Optionally specify the start time for all of your manifest egress requests. When you include start time,
     *         note that you cannot use start time query parameters for this manifest's endpoint URL.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * Optionally specify the end time for all of your manifest egress requests. When you include end time, note that
     * you cannot use end time query parameters for this manifest's endpoint URL.
     * </p>
     * 
     * @return Optionally specify the end time for all of your manifest egress requests. When you include end time, note
     *         that you cannot use end time query parameters for this manifest's endpoint URL.
     */
    public final Instant end() {
        return end;
    }

    /**
     * <p>
     * Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than
     * your endpoint's startover window. When you include time delay, note that you cannot use time delay query
     * parameters for this manifest's endpoint URL.
     * </p>
     * 
     * @return Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller
     *         than your endpoint's startover window. When you include time delay, note that you cannot use time delay
     *         query parameters for this manifest's endpoint URL.
     */
    public final Integer timeDelaySeconds() {
        return timeDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestFilter());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(timeDelaySeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterConfiguration)) {
            return false;
        }
        FilterConfiguration other = (FilterConfiguration) obj;
        return Objects.equals(manifestFilter(), other.manifestFilter()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end()) && Objects.equals(timeDelaySeconds(), other.timeDelaySeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterConfiguration").add("ManifestFilter", manifestFilter()).add("Start", start())
                .add("End", end()).add("TimeDelaySeconds", timeDelaySeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestFilter":
            return Optional.ofNullable(clazz.cast(manifestFilter()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "TimeDelaySeconds":
            return Optional.ofNullable(clazz.cast(timeDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterConfiguration, T> g) {
        return obj -> g.apply((FilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterConfiguration> {
        /**
         * <p>
         * Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a
         * manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's
         * endpoint URL.
         * </p>
         * 
         * @param manifestFilter
         *        Optionally specify one or more manifest filters for all of your manifest egress requests. When you
         *        include a manifest filter, note that you cannot use an identical manifest filter query parameter for
         *        this manifest's endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestFilter(String manifestFilter);

        /**
         * <p>
         * Optionally specify the start time for all of your manifest egress requests. When you include start time, note
         * that you cannot use start time query parameters for this manifest's endpoint URL.
         * </p>
         * 
         * @param start
         *        Optionally specify the start time for all of your manifest egress requests. When you include start
         *        time, note that you cannot use start time query parameters for this manifest's endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * Optionally specify the end time for all of your manifest egress requests. When you include end time, note
         * that you cannot use end time query parameters for this manifest's endpoint URL.
         * </p>
         * 
         * @param end
         *        Optionally specify the end time for all of your manifest egress requests. When you include end time,
         *        note that you cannot use end time query parameters for this manifest's endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller
         * than your endpoint's startover window. When you include time delay, note that you cannot use time delay query
         * parameters for this manifest's endpoint URL.
         * </p>
         * 
         * @param timeDelaySeconds
         *        Optionally specify the time delay for all of your manifest egress requests. Enter a value that is
         *        smaller than your endpoint's startover window. When you include time delay, note that you cannot use
         *        time delay query parameters for this manifest's endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDelaySeconds(Integer timeDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private String manifestFilter;

        private Instant start;

        private Instant end;

        private Integer timeDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterConfiguration model) {
            manifestFilter(model.manifestFilter);
            start(model.start);
            end(model.end);
            timeDelaySeconds(model.timeDelaySeconds);
        }

        public final String getManifestFilter() {
            return manifestFilter;
        }

        public final void setManifestFilter(String manifestFilter) {
            this.manifestFilter = manifestFilter;
        }

        @Override
        public final Builder manifestFilter(String manifestFilter) {
            this.manifestFilter = manifestFilter;
            return this;
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Integer getTimeDelaySeconds() {
            return timeDelaySeconds;
        }

        public final void setTimeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
        }

        @Override
        public final Builder timeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
            return this;
        }

        @Override
        public FilterConfiguration build() {
            return new FilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
