/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackagev2.DefaultMediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.DefaultMediaPackageV2BaseClientBuilder;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClientBuilder;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2ServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackagev2.endpoints.MediaPackageV2EndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageV2AsyncClientBuilder
extends DefaultMediaPackageV2BaseClientBuilder<MediaPackageV2AsyncClientBuilder, MediaPackageV2AsyncClient>
implements MediaPackageV2AsyncClientBuilder {
    DefaultMediaPackageV2AsyncClientBuilder() {
    }

    @Override
    public DefaultMediaPackageV2AsyncClientBuilder endpointProvider(MediaPackageV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaPackageV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaPackageV2ServiceClientConfiguration serviceClientConfiguration = MediaPackageV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaPackageV2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

