/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List the low-latency HTTP live streaming (HLS) manifest configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLowLatencyHlsManifestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ListLowLatencyHlsManifestConfiguration.Builder, ListLowLatencyHlsManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(ListLowLatencyHlsManifestConfiguration::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<String> CHILD_MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChildManifestName").getter(getter(ListLowLatencyHlsManifestConfiguration::childManifestName))
            .setter(setter(Builder::childManifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildManifestName").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(ListLowLatencyHlsManifestConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD,
            CHILD_MANIFEST_NAME_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestName;

    private final String childManifestName;

    private final String url;

    private ListLowLatencyHlsManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.childManifestName = builder.childManifestName;
        this.url = builder.url;
    }

    /**
     * <p>
     * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS
     * manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you
     * provided on the originEndpoint object.
     * </p>
     * 
     * @return A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     *         automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you
     *         use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
     *         manifestName you provided on the originEndpoint object.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
     * manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
     * </p>
     * 
     * @return A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
     *         manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint
     *         object.
     */
    public final String childManifestName() {
        return childManifestName;
    }

    /**
     * <p>
     * The egress domain URL for stream delivery from MediaPackage.
     * </p>
     * 
     * @return The egress domain URL for stream delivery from MediaPackage.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(childManifestName());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLowLatencyHlsManifestConfiguration)) {
            return false;
        }
        ListLowLatencyHlsManifestConfiguration other = (ListLowLatencyHlsManifestConfiguration) obj;
        return Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(childManifestName(), other.childManifestName()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLowLatencyHlsManifestConfiguration").add("ManifestName", manifestName())
                .add("ChildManifestName", childManifestName()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "ChildManifestName":
            return Optional.ofNullable(clazz.cast(childManifestName()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLowLatencyHlsManifestConfiguration, T> g) {
        return obj -> g.apply((ListLowLatencyHlsManifestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListLowLatencyHlsManifestConfiguration> {
        /**
         * <p>
         * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
         * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use
         * HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
         * manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param manifestName
         *        A short short string that's appended to the endpoint URL. The manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
         *        MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same
         *        manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the
         *        HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The
         * manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param childManifestName
         *        A short string that's appended to the endpoint URL. The child manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1.
         *        The manifestName on the HLSManifest object overrides the manifestName you provided on the
         *        originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childManifestName(String childManifestName);

        /**
         * <p>
         * The egress domain URL for stream delivery from MediaPackage.
         * </p>
         * 
         * @param url
         *        The egress domain URL for stream delivery from MediaPackage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String manifestName;

        private String childManifestName;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLowLatencyHlsManifestConfiguration model) {
            manifestName(model.manifestName);
            childManifestName(model.childManifestName);
            url(model.url);
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getChildManifestName() {
            return childManifestName;
        }

        public final void setChildManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
        }

        @Override
        public final Builder childManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public ListLowLatencyHlsManifestConfiguration build() {
            return new ListLowLatencyHlsManifestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
