/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest;
import software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyResponse;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.TagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest;
import software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointResponse;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsPublisher;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsPublisher;

/**
 * Service client for accessing mediapackagev2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <note>
 * <p>
 * This guide is intended for creating AWS Elemental MediaPackage resources in MediaPackage Version 2 (v2) starting from
 * May 2023. To get started with MediaPackage v2, create your MediaPackage resources. There isn't an automated process
 * to migrate your resources from MediaPackage v1 to MediaPackage v2.
 * </p>
 * <p>
 * The names of the entities that you use to access this API, like URLs and ARNs, all have the versioning information
 * added, like "v2", to distinguish from the prior version. If you used MediaPackage prior to this release, you can't
 * use the MediaPackage v2 CLI or the MediaPackage v2 API to access any MediaPackage v1 resources.
 * </p>
 * <p>
 * If you created resources in MediaPackage v1, use video on demand (VOD) workflows, and aren't looking to migrate to
 * MediaPackage v2 yet, see the <a
 * href="https://docs.aws.amazon.com/mediapackage/latest/apireference/what-is.html">MediaPackage v1 Live API
 * Reference</a>.
 * </p>
 * </note>
 * <p>
 * This is the AWS Elemental MediaPackage v2 Live REST API Reference. It describes all the MediaPackage API operations
 * for live content in detail, and provides sample requests, responses, and errors for the supported web services
 * protocols.
 * </p>
 * <p>
 * We assume that you have the IAM permissions that you need to use MediaPackage via the REST API. We also assume that
 * you are familiar with the features and operations of MediaPackage, as described in the AWS Elemental MediaPackage
 * User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaPackageV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "mediapackagev2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediapackagev2";

    /**
     * <p>
     * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for
     * incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after
     * packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that
     * request the content. You can create only one channel with each request. We recommend that you spread out channels
     * between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
     * </p>
     *
     * @param createChannelRequest
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for
     * incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after
     * packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that
     * request the content. You can create only one channel with each request. We recommend that you spread out channels
     * between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource
     * that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for
     * stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You
     * can create only one channel group with each request.
     * </p>
     *
     * @param createChannelGroupRequest
     * @return A Java Future containing the result of the CreateChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChannelGroupResponse> createChannelGroup(CreateChannelGroupRequest createChannelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource
     * that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for
     * stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You
     * can create only one channel group with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateChannelGroupRequest#builder()}
     * </p>
     *
     * @param createChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChannelGroupResponse> createChannelGroup(
            Consumer<CreateChannelGroupRequest.Builder> createChannelGroupRequest) {
        return createChannelGroup(CreateChannelGroupRequest.builder().applyMutation(createChannelGroupRequest).build());
    }

    /**
     * <p>
     * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple
     * endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access
     * to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only
     * one endpoint with each request.
     * </p>
     *
     * @param createOriginEndpointRequest
     * @return A Java Future containing the result of the CreateOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOriginEndpointResponse> createOriginEndpoint(
            CreateOriginEndpointRequest createOriginEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple
     * endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access
     * to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only
     * one endpoint with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOriginEndpointRequest#builder()}
     * </p>
     *
     * @param createOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.CreateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOriginEndpointResponse> createOriginEndpoint(
            Consumer<CreateOriginEndpointRequest.Builder> createOriginEndpointRequest) {
        return createOriginEndpoint(CreateOriginEndpointRequest.builder().applyMutation(createOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's
     * origin endpoints before you can delete the channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's
     * origin endpoints before you can delete the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete
     * the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create
     * a new channel group to replace it.
     * </p>
     *
     * @param deleteChannelGroupRequest
     * @return A Java Future containing the result of the DeleteChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChannelGroupResponse> deleteChannelGroup(DeleteChannelGroupRequest deleteChannelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete
     * the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create
     * a new channel group to replace it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelGroupRequest#builder()}
     * </p>
     *
     * @param deleteChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChannelGroupResponse> deleteChannelGroup(
            Consumer<DeleteChannelGroupRequest.Builder> deleteChannelGroupRequest) {
        return deleteChannelGroup(DeleteChannelGroupRequest.builder().applyMutation(deleteChannelGroupRequest).build());
    }

    /**
     * <p>
     * Delete a channel policy.
     * </p>
     *
     * @param deleteChannelPolicyRequest
     * @return A Java Future containing the result of the DeleteChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChannelPolicyResponse> deleteChannelPolicy(
            DeleteChannelPolicyRequest deleteChannelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a channel policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChannelPolicyResponse> deleteChannelPolicy(
            Consumer<DeleteChannelPolicyRequest.Builder> deleteChannelPolicyRequest) {
        return deleteChannelPolicy(DeleteChannelPolicyRequest.builder().applyMutation(deleteChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to
     * playback requests. You must delete all endpoints from a channel before you can delete the channel.
     * </p>
     *
     * @param deleteOriginEndpointRequest
     * @return A Java Future containing the result of the DeleteOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginEndpointResponse> deleteOriginEndpoint(
            DeleteOriginEndpointRequest deleteOriginEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to
     * playback requests. You must delete all endpoints from a channel before you can delete the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOriginEndpointRequest#builder()}
     * </p>
     *
     * @param deleteOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginEndpointResponse> deleteOriginEndpoint(
            Consumer<DeleteOriginEndpointRequest.Builder> deleteOriginEndpointRequest) {
        return deleteOriginEndpoint(DeleteOriginEndpointRequest.builder().applyMutation(deleteOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Delete an origin endpoint policy.
     * </p>
     *
     * @param deleteOriginEndpointPolicyRequest
     * @return A Java Future containing the result of the DeleteOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginEndpointPolicyResponse> deleteOriginEndpointPolicy(
            DeleteOriginEndpointPolicyRequest deleteOriginEndpointPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin endpoint policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param deleteOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.DeleteOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginEndpointPolicyResponse> deleteOriginEndpointPolicy(
            Consumer<DeleteOriginEndpointPolicyRequest.Builder> deleteOriginEndpointPolicyRequest) {
        return deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest.builder()
                .applyMutation(deleteOriginEndpointPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel that's configured in AWS Elemental MediaPackage, including the origin endpoints
     * that are associated with it.
     * </p>
     *
     * @param getChannelRequest
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel that's configured in AWS Elemental MediaPackage, including the origin endpoints
     * that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest) {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage, including the channels and
     * origin endpoints that are associated with it.
     * </p>
     *
     * @param getChannelGroupRequest
     * @return A Java Future containing the result of the GetChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChannelGroupResponse> getChannelGroup(GetChannelGroupRequest getChannelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage, including the channels and
     * origin endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelGroupRequest#builder()}
     * </p>
     *
     * @param getChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChannelGroupResponse> getChannelGroup(
            Consumer<GetChannelGroupRequest.Builder> getChannelGroupRequest) {
        return getChannelGroup(GetChannelGroupRequest.builder().applyMutation(getChannelGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can
     * specify who has access to AWS resources and what actions they can perform on those resources.
     * </p>
     *
     * @param getChannelPolicyRequest
     * @return A Java Future containing the result of the GetChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChannelPolicyResponse> getChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can
     * specify who has access to AWS resources and what actions they can perform on those resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelPolicyRequest#builder()}
     * </p>
     *
     * @param getChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChannelPolicyResponse> getChannelPolicy(
            Consumer<GetChannelPolicyRequest.Builder> getChannelPolicyRequest) {
        return getChannelPolicy(GetChannelPolicyRequest.builder().applyMutation(getChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback
     * URL and to view the packaging settings that it's currently using.
     * </p>
     *
     * @param getOriginEndpointRequest
     * @return A Java Future containing the result of the GetOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginEndpointResponse> getOriginEndpoint(GetOriginEndpointRequest getOriginEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback
     * URL and to view the packaging settings that it's currently using.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link GetOriginEndpointRequest#builder()}
     * </p>
     *
     * @param getOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginEndpointResponse> getOriginEndpoint(
            Consumer<GetOriginEndpointRequest.Builder> getOriginEndpointRequest) {
        return getOriginEndpoint(GetOriginEndpointRequest.builder().applyMutation(getOriginEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param getOriginEndpointPolicyRequest
     * @return A Java Future containing the result of the GetOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginEndpointPolicyResponse> getOriginEndpointPolicy(
            GetOriginEndpointPolicyRequest getOriginEndpointPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param getOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.GetOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginEndpointPolicyResponse> getOriginEndpointPolicy(
            Consumer<GetOriginEndpointPolicyRequest.Builder> getOriginEndpointPolicyRequest) {
        return getOriginEndpointPolicy(GetOriginEndpointPolicyRequest.builder().applyMutation(getOriginEndpointPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin
     * endpoints that are associated with it.
     * </p>
     *
     * @param listChannelGroupsRequest
     * @return A Java Future containing the result of the ListChannelGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChannelGroupsResponse> listChannelGroups(ListChannelGroupsRequest listChannelGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin
     * endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListChannelGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChannelGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChannelGroupsResponse> listChannelGroups(
            Consumer<ListChannelGroupsRequest.Builder> listChannelGroupsRequest) {
        return listChannelGroups(ListChannelGroupsRequest.builder().applyMutation(listChannelGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin
     * endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsPublisher publisher = client.listChannelGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsPublisher publisher = client.listChannelGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChannelGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsPublisher listChannelGroupsPaginator(ListChannelGroupsRequest listChannelGroupsRequest) {
        return new ListChannelGroupsPublisher(this, listChannelGroupsRequest);
    }

    /**
     * <p>
     * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin
     * endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsPublisher publisher = client.listChannelGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelGroupsPublisher publisher = client.listChannelGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelGroups(software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListChannelGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelGroupsPublisher listChannelGroupsPaginator(
            Consumer<ListChannelGroupsRequest.Builder> listChannelGroupsRequest) {
        return listChannelGroupsPaginator(ListChannelGroupsRequest.builder().applyMutation(listChannelGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including
     * the origin endpoints that are associated with it.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including
     * the origin endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including
     * the origin endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including
     * the origin endpoints that are associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     *
     * @param listOriginEndpointsRequest
     * @return A Java Future containing the result of the ListOriginEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOriginEndpointsResponse> listOriginEndpoints(
            ListOriginEndpointsRequest listOriginEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginEndpointsRequest#builder()}
     * </p>
     *
     * @param listOriginEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListOriginEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOriginEndpointsResponse> listOriginEndpoints(
            Consumer<ListOriginEndpointsRequest.Builder> listOriginEndpointsRequest) {
        return listOriginEndpoints(ListOriginEndpointsRequest.builder().applyMutation(listOriginEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsPublisher publisher = client.listOriginEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsPublisher publisher = client.listOriginEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOriginEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsPublisher listOriginEndpointsPaginator(ListOriginEndpointsRequest listOriginEndpointsRequest) {
        return new ListOriginEndpointsPublisher(this, listOriginEndpointsRequest);
    }

    /**
     * <p>
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsPublisher publisher = client.listOriginEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediapackagev2.paginators.ListOriginEndpointsPublisher publisher = client.listOriginEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginEndpoints(software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginEndpointsRequest#builder()}
     * </p>
     *
     * @param listOriginEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListOriginEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginEndpointsPublisher listOriginEndpointsPaginator(
            Consumer<ListOriginEndpointsRequest.Builder> listOriginEndpointsRequest) {
        return listOriginEndpointsPaginator(ListOriginEndpointsRequest.builder().applyMutation(listOriginEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources
     * and what actions they can perform on those resources. You can attach only one policy with each request.
     * </p>
     *
     * @param putChannelPolicyRequest
     * @return A Java Future containing the result of the PutChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutChannelPolicyResponse> putChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources
     * and what actions they can perform on those resources. You can attach only one policy with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutChannelPolicyRequest#builder()}
     * </p>
     *
     * @param putChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutChannelPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutChannelPolicyResponse> putChannelPolicy(
            Consumer<PutChannelPolicyRequest.Builder> putChannelPolicyRequest) {
        return putChannelPolicy(PutChannelPolicyRequest.builder().applyMutation(putChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
     * </p>
     *
     * @param putOriginEndpointPolicyRequest
     * @return A Java Future containing the result of the PutOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.PutOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOriginEndpointPolicyResponse> putOriginEndpointPolicy(
            PutOriginEndpointPolicyRequest putOriginEndpointPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOriginEndpointPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutOriginEndpointPolicyRequest#builder()}
     * </p>
     *
     * @param putOriginEndpointPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutOriginEndpointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.PutOriginEndpointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOriginEndpointPolicyResponse> putOriginEndpointPolicy(
            Consumer<PutOriginEndpointPolicyRequest.Builder> putOriginEndpointPolicyRequest) {
        return putOriginEndpointPolicy(PutOriginEndpointPolicyRequest.builder().applyMutation(putOriginEndpointPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this
     * tag is appended to the list of tags associated with the resource. If you specify a tag key that is already
     * associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this
     * tag is appended to the list of tags associated with the resource. If you specify a tag key that is already
     * associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch
     * log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You
     * can't edit the name of the channel or CloudFront distribution details.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateChannelRequest
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch
     * log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You
     * can't edit the name of the channel or CloudFront distribution details.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Update the specified channel group. You can edit the description on a channel group for easier identification
     * later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateChannelGroupRequest
     * @return A Java Future containing the result of the UpdateChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChannelGroupResponse> updateChannelGroup(UpdateChannelGroupRequest updateChannelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified channel group. You can edit the description on a channel group for easier identification
     * later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelGroupRequest#builder()}
     * </p>
     *
     * @param updateChannelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateChannelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateChannelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChannelGroupResponse> updateChannelGroup(
            Consumer<UpdateChannelGroupRequest.Builder> updateChannelGroupRequest) {
        return updateChannelGroup(UpdateChannelGroupRequest.builder().applyMutation(updateChannelGroupRequest).build());
    }

    /**
     * <p>
     * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing
     * experience. You can't edit the name of the endpoint.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     *
     * @param updateOriginEndpointRequest
     * @return A Java Future containing the result of the UpdateOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOriginEndpointResponse> updateOriginEndpoint(
            UpdateOriginEndpointRequest updateOriginEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing
     * experience. You can't edit the name of the endpoint.
     * </p>
     * <p>
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOriginEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateOriginEndpointRequest#builder()}
     * </p>
     *
     * @param updateOriginEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateOriginEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException Indicates that an error from the service occurred while trying to process a
     *         request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see Access Management in the IAM User Guide.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaPackageV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MediaPackageV2AsyncClient.UpdateOriginEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOriginEndpointResponse> updateOriginEndpoint(
            Consumer<UpdateOriginEndpointRequest.Builder> updateOriginEndpointRequest) {
        return updateOriginEndpoint(UpdateOriginEndpointRequest.builder().applyMutation(updateOriginEndpointRequest).build());
    }

    @Override
    default MediaPackageV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaPackageV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaPackageV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaPackageV2AsyncClient}.
     */
    static MediaPackageV2AsyncClientBuilder builder() {
        return new DefaultMediaPackageV2AsyncClientBuilder();
    }
}
