/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to determine whether a message
 * signals an ad. Choosing "NONE" means no SCTE-35 messages become ads. Choosing "RESTRICTED" means SCTE-35 messages of
 * the types specified in AdTriggers that contain delivery restrictions will be treated as ads. Choosing "UNRESTRICTED"
 * means SCTE-35 messages of the types specified in AdTriggers that do not contain delivery restrictions will be treated
 * as ads. Choosing "BOTH" means all SCTE-35 messages of the types specified in AdTriggers will be treated as ads. Note
 * that Splice Insert messages do not have these flags and are always treated as ads if specified in AdTriggers.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AdsOnDeliveryRestrictions {
    NONE("NONE"),

    RESTRICTED("RESTRICTED"),

    UNRESTRICTED("UNRESTRICTED"),

    BOTH("BOTH"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdsOnDeliveryRestrictions> VALUE_MAP = EnumUtils.uniqueIndex(
            AdsOnDeliveryRestrictions.class, AdsOnDeliveryRestrictions::toString);

    private final String value;

    private AdsOnDeliveryRestrictions(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AdsOnDeliveryRestrictions corresponding to the value
     */
    public static AdsOnDeliveryRestrictions fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AdsOnDeliveryRestrictions}s
     */
    public static Set<AdsOnDeliveryRestrictions> knownValues() {
        Set<AdsOnDeliveryRestrictions> knownValues = EnumSet.allOf(AdsOnDeliveryRestrictions.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
