/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The output of the bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BridgeOutput implements SdkPojo, Serializable, ToCopyableBuilder<BridgeOutput.Builder, BridgeOutput> {
    private static final SdkField<BridgeFlowOutput> FLOW_OUTPUT_FIELD = SdkField
            .<BridgeFlowOutput> builder(MarshallingType.SDK_POJO).memberName("FlowOutput")
            .getter(getter(BridgeOutput::flowOutput)).setter(setter(Builder::flowOutput)).constructor(BridgeFlowOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutput").build()).build();

    private static final SdkField<BridgeNetworkOutput> NETWORK_OUTPUT_FIELD = SdkField
            .<BridgeNetworkOutput> builder(MarshallingType.SDK_POJO).memberName("NetworkOutput")
            .getter(getter(BridgeOutput::networkOutput)).setter(setter(Builder::networkOutput))
            .constructor(BridgeNetworkOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OUTPUT_FIELD,
            NETWORK_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final BridgeFlowOutput flowOutput;

    private final BridgeNetworkOutput networkOutput;

    private BridgeOutput(BuilderImpl builder) {
        this.flowOutput = builder.flowOutput;
        this.networkOutput = builder.networkOutput;
    }

    /**
     * Returns the value of the FlowOutput property for this object.
     * 
     * @return The value of the FlowOutput property for this object.
     */
    public final BridgeFlowOutput flowOutput() {
        return flowOutput;
    }

    /**
     * Returns the value of the NetworkOutput property for this object.
     * 
     * @return The value of the NetworkOutput property for this object.
     */
    public final BridgeNetworkOutput networkOutput() {
        return networkOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowOutput());
        hashCode = 31 * hashCode + Objects.hashCode(networkOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeOutput)) {
            return false;
        }
        BridgeOutput other = (BridgeOutput) obj;
        return Objects.equals(flowOutput(), other.flowOutput()) && Objects.equals(networkOutput(), other.networkOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BridgeOutput").add("FlowOutput", flowOutput()).add("NetworkOutput", networkOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowOutput":
            return Optional.ofNullable(clazz.cast(flowOutput()));
        case "NetworkOutput":
            return Optional.ofNullable(clazz.cast(networkOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BridgeOutput, T> g) {
        return obj -> g.apply((BridgeOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BridgeOutput> {
        /**
         * Sets the value of the FlowOutput property for this object.
         *
         * @param flowOutput
         *        The new value for the FlowOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOutput(BridgeFlowOutput flowOutput);

        /**
         * Sets the value of the FlowOutput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BridgeFlowOutput.Builder} avoiding the
         * need to create one manually via {@link BridgeFlowOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BridgeFlowOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #flowOutput(BridgeFlowOutput)}.
         * 
         * @param flowOutput
         *        a consumer that will call methods on {@link BridgeFlowOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowOutput(BridgeFlowOutput)
         */
        default Builder flowOutput(Consumer<BridgeFlowOutput.Builder> flowOutput) {
            return flowOutput(BridgeFlowOutput.builder().applyMutation(flowOutput).build());
        }

        /**
         * Sets the value of the NetworkOutput property for this object.
         *
         * @param networkOutput
         *        The new value for the NetworkOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOutput(BridgeNetworkOutput networkOutput);

        /**
         * Sets the value of the NetworkOutput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BridgeNetworkOutput.Builder} avoiding the
         * need to create one manually via {@link BridgeNetworkOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BridgeNetworkOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #networkOutput(BridgeNetworkOutput)}.
         * 
         * @param networkOutput
         *        a consumer that will call methods on {@link BridgeNetworkOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkOutput(BridgeNetworkOutput)
         */
        default Builder networkOutput(Consumer<BridgeNetworkOutput.Builder> networkOutput) {
            return networkOutput(BridgeNetworkOutput.builder().applyMutation(networkOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BridgeFlowOutput flowOutput;

        private BridgeNetworkOutput networkOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeOutput model) {
            flowOutput(model.flowOutput);
            networkOutput(model.networkOutput);
        }

        public final BridgeFlowOutput.Builder getFlowOutput() {
            return flowOutput != null ? flowOutput.toBuilder() : null;
        }

        public final void setFlowOutput(BridgeFlowOutput.BuilderImpl flowOutput) {
            this.flowOutput = flowOutput != null ? flowOutput.build() : null;
        }

        @Override
        public final Builder flowOutput(BridgeFlowOutput flowOutput) {
            this.flowOutput = flowOutput;
            return this;
        }

        public final BridgeNetworkOutput.Builder getNetworkOutput() {
            return networkOutput != null ? networkOutput.toBuilder() : null;
        }

        public final void setNetworkOutput(BridgeNetworkOutput.BuilderImpl networkOutput) {
            this.networkOutput = networkOutput != null ? networkOutput.build() : null;
        }

        @Override
        public final Builder networkOutput(BridgeNetworkOutput networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        @Override
        public BridgeOutput build() {
            return new BridgeOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
