/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The output of the bridge. A flow output is delivered to the AWS cloud.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BridgeFlowOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<BridgeFlowOutput.Builder, BridgeFlowOutput> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(BridgeFlowOutput::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> FLOW_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowSourceArn").getter(getter(BridgeFlowOutput::flowSourceArn)).setter(setter(Builder::flowSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSourceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BridgeFlowOutput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_SOURCE_ARN_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String flowSourceArn;

    private final String name;

    private BridgeFlowOutput(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowSourceArn = builder.flowSourceArn;
        this.name = builder.name;
    }

    /**
     * The Amazon Resource Number (ARN) of the cloud flow.
     * 
     * @return The Amazon Resource Number (ARN) of the cloud flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The Amazon Resource Number (ARN) of the flow source.
     * 
     * @return The Amazon Resource Number (ARN) of the flow source.
     */
    public final String flowSourceArn() {
        return flowSourceArn;
    }

    /**
     * The name of the bridge's output.
     * 
     * @return The name of the bridge's output.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeFlowOutput)) {
            return false;
        }
        BridgeFlowOutput other = (BridgeFlowOutput) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(flowSourceArn(), other.flowSourceArn())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BridgeFlowOutput").add("FlowArn", flowArn()).add("FlowSourceArn", flowSourceArn())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "FlowSourceArn":
            return Optional.ofNullable(clazz.cast(flowSourceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BridgeFlowOutput, T> g) {
        return obj -> g.apply((BridgeFlowOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BridgeFlowOutput> {
        /**
         * The Amazon Resource Number (ARN) of the cloud flow.
         * 
         * @param flowArn
         *        The Amazon Resource Number (ARN) of the cloud flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The Amazon Resource Number (ARN) of the flow source.
         * 
         * @param flowSourceArn
         *        The Amazon Resource Number (ARN) of the flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowSourceArn(String flowSourceArn);

        /**
         * The name of the bridge's output.
         * 
         * @param name
         *        The name of the bridge's output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String flowSourceArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeFlowOutput model) {
            flowArn(model.flowArn);
            flowSourceArn(model.flowSourceArn);
            name(model.name);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowSourceArn() {
            return flowSourceArn;
        }

        public final void setFlowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
        }

        @Override
        public final Builder flowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public BridgeFlowOutput build() {
            return new BridgeFlowOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
