/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a change set returned in a list of change sets when the <code>ListChangeSets</code> action is called.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSetSummaryListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeSetSummaryListItem.Builder, ChangeSetSummaryListItem> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetId").getter(getter(ChangeSetSummaryListItem::changeSetId)).setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()).build();

    private static final SdkField<String> CHANGE_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetArn").getter(getter(ChangeSetSummaryListItem::changeSetArn))
            .setter(setter(Builder::changeSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetArn").build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(ChangeSetSummaryListItem::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(ChangeSetSummaryListItem::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(ChangeSetSummaryListItem::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ChangeSetSummaryListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> ENTITY_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntityIdList")
            .getter(getter(ChangeSetSummaryListItem::entityIdList))
            .setter(setter(Builder::entityIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(ChangeSetSummaryListItem::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD,
            CHANGE_SET_ARN_FIELD, CHANGE_SET_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ENTITY_ID_LIST_FIELD,
            FAILURE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changeSetId;

    private final String changeSetArn;

    private final String changeSetName;

    private final String startTime;

    private final String endTime;

    private final String status;

    private final List<String> entityIdList;

    private final String failureCode;

    private ChangeSetSummaryListItem(BuilderImpl builder) {
        this.changeSetId = builder.changeSetId;
        this.changeSetArn = builder.changeSetArn;
        this.changeSetName = builder.changeSetName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.entityIdList = builder.entityIdList;
        this.failureCode = builder.failureCode;
    }

    /**
     * <p>
     * The unique identifier for a change set.
     * </p>
     * 
     * @return The unique identifier for a change set.
     */
    public final String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The ARN associated with the unique identifier for the change set referenced in this request.
     * </p>
     * 
     * @return The ARN associated with the unique identifier for the change set referenced in this request.
     */
    public final String changeSetArn() {
        return changeSetArn;
    }

    /**
     * <p>
     * The non-unique name for the change set.
     * </p>
     * 
     * @return The non-unique name for the change set.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was started.
     * </p>
     * 
     * @return The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was finished.
     * </p>
     * 
     * @return The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was finished.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The current status of the change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the change set.
     * @see ChangeStatus
     */
    public final ChangeStatus status() {
        return ChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the change set.
     * @see ChangeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityIdList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityIdList() {
        return entityIdList != null && !(entityIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a maximum of
     * 20 entities. It must contain at least one entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityIdList} method.
     * </p>
     * 
     * @return This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a
     *         maximum of 20 entities. It must contain at least one entity.
     */
    public final List<String> entityIdList() {
        return entityIdList;
    }

    /**
     * <p>
     * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means
     * that there are issues with the request (see the <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>),
     * or <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
     *         which means that there are issues with the request (see the <code>ErrorDetailList</code> of
     *         <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the
     *         system, and you should retry your request.
     * @see FailureCode
     */
    public final FailureCode failureCode() {
        return FailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means
     * that there are issues with the request (see the <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>),
     * or <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
     *         which means that there are issues with the request (see the <code>ErrorDetailList</code> of
     *         <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the
     *         system, and you should retry your request.
     * @see FailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityIdList() ? entityIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummaryListItem)) {
            return false;
        }
        ChangeSetSummaryListItem other = (ChangeSetSummaryListItem) obj;
        return Objects.equals(changeSetId(), other.changeSetId()) && Objects.equals(changeSetArn(), other.changeSetArn())
                && Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasEntityIdList() == other.hasEntityIdList() && Objects.equals(entityIdList(), other.entityIdList())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSetSummaryListItem").add("ChangeSetId", changeSetId()).add("ChangeSetArn", changeSetArn())
                .add("ChangeSetName", changeSetName()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Status", statusAsString()).add("EntityIdList", hasEntityIdList() ? entityIdList() : null)
                .add("FailureCode", failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "ChangeSetArn":
            return Optional.ofNullable(clazz.cast(changeSetArn()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EntityIdList":
            return Optional.ofNullable(clazz.cast(entityIdList()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetSummaryListItem, T> g) {
        return obj -> g.apply((ChangeSetSummaryListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSetSummaryListItem> {
        /**
         * <p>
         * The unique identifier for a change set.
         * </p>
         * 
         * @param changeSetId
         *        The unique identifier for a change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The ARN associated with the unique identifier for the change set referenced in this request.
         * </p>
         * 
         * @param changeSetArn
         *        The ARN associated with the unique identifier for the change set referenced in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetArn(String changeSetArn);

        /**
         * <p>
         * The non-unique name for the change set.
         * </p>
         * 
         * @param changeSetName
         *        The non-unique name for the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was started.
         * </p>
         * 
         * @param startTime
         *        The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was finished.
         * </p>
         * 
         * @param endTime
         *        The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The current status of the change set.
         * </p>
         * 
         * @param status
         *        The current status of the change set.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the change set.
         * </p>
         * 
         * @param status
         *        The current status of the change set.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a maximum
         * of 20 entities. It must contain at least one entity.
         * </p>
         * 
         * @param entityIdList
         *        This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a
         *        maximum of 20 entities. It must contain at least one entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdList(Collection<String> entityIdList);

        /**
         * <p>
         * This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a maximum
         * of 20 entities. It must contain at least one entity.
         * </p>
         * 
         * @param entityIdList
         *        This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a
         *        maximum of 20 entities. It must contain at least one entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdList(String... entityIdList);

        /**
         * <p>
         * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which
         * means that there are issues with the request (see the <code>ErrorDetailList</code> of
         * <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the
         * system, and you should retry your request.
         * </p>
         * 
         * @param failureCode
         *        Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
         *        which means that there are issues with the request (see the <code>ErrorDetailList</code> of
         *        <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in
         *        the system, and you should retry your request.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which
         * means that there are issues with the request (see the <code>ErrorDetailList</code> of
         * <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the
         * system, and you should retry your request.
         * </p>
         * 
         * @param failureCode
         *        Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
         *        which means that there are issues with the request (see the <code>ErrorDetailList</code> of
         *        <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in
         *        the system, and you should retry your request.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(FailureCode failureCode);
    }

    static final class BuilderImpl implements Builder {
        private String changeSetId;

        private String changeSetArn;

        private String changeSetName;

        private String startTime;

        private String endTime;

        private String status;

        private List<String> entityIdList = DefaultSdkAutoConstructList.getInstance();

        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummaryListItem model) {
            changeSetId(model.changeSetId);
            changeSetArn(model.changeSetArn);
            changeSetName(model.changeSetName);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            entityIdList(model.entityIdList);
            failureCode(model.failureCode);
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetArn() {
            return changeSetArn;
        }

        public final void setChangeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
        }

        @Override
        public final Builder changeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
            return this;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getEntityIdList() {
            if (entityIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return entityIdList;
        }

        public final void setEntityIdList(Collection<String> entityIdList) {
            this.entityIdList = ResourceIdListCopier.copy(entityIdList);
        }

        @Override
        public final Builder entityIdList(Collection<String> entityIdList) {
            this.entityIdList = ResourceIdListCopier.copy(entityIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIdList(String... entityIdList) {
            entityIdList(Arrays.asList(entityIdList));
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        @Override
        public ChangeSetSummaryListItem build() {
            return new ChangeSetSummaryListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
