/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object is a container for common summary information about the entity. The summary doesn't contain the whole
 * entity structure, but it does contain information common across all entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitySummary implements SdkPojo, Serializable, ToCopyableBuilder<EntitySummary.Builder, EntitySummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EntitySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(EntitySummary::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(EntitySummary::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(EntitySummary::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EntitySummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(EntitySummary::visibility)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENTITY_TYPE_FIELD,
            ENTITY_ID_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String entityType;

    private final String entityId;

    private final String entityArn;

    private final String lastModifiedDate;

    private final String visibility;

    private EntitySummary(BuilderImpl builder) {
        this.name = builder.name;
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The name for the entity. This value is not unique. It is defined by the seller.
     * </p>
     * 
     * @return The name for the entity. This value is not unique. It is defined by the seller.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the entity.
     * </p>
     * 
     * @return The type of the entity.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The unique identifier for the entity.
     * </p>
     * 
     * @return The unique identifier for the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The ARN associated with the unique identifier for the entity.
     * </p>
     * 
     * @return The ARN associated with the unique identifier for the entity.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
     * </p>
     * 
     * @return The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view the
     * entity), <code>Limited</code> (the entity is visible to limited accounts only), or <code>Restricted</code> (the
     * entity was published and then unpublished and only existing buyers can view it).
     * </p>
     * 
     * @return The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view
     *         the entity), <code>Limited</code> (the entity is visible to limited accounts only), or
     *         <code>Restricted</code> (the entity was published and then unpublished and only existing buyers can view
     *         it).
     */
    public final String visibility() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(entityType(), other.entityType())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(visibility(), other.visibility());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitySummary").add("Name", name()).add("EntityType", entityType()).add("EntityId", entityId())
                .add("EntityArn", entityArn()).add("LastModifiedDate", lastModifiedDate()).add("Visibility", visibility())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitySummary> {
        /**
         * <p>
         * The name for the entity. This value is not unique. It is defined by the seller.
         * </p>
         * 
         * @param name
         *        The name for the entity. This value is not unique. It is defined by the seller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the entity.
         * </p>
         * 
         * @param entityType
         *        The type of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The unique identifier for the entity.
         * </p>
         * 
         * @param entityId
         *        The unique identifier for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The ARN associated with the unique identifier for the entity.
         * </p>
         * 
         * @param entityArn
         *        The ARN associated with the unique identifier for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
         * </p>
         * 
         * @param lastModifiedDate
         *        The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view the
         * entity), <code>Limited</code> (the entity is visible to limited accounts only), or <code>Restricted</code>
         * (the entity was published and then unpublished and only existing buyers can view it).
         * </p>
         * 
         * @param visibility
         *        The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can
         *        view the entity), <code>Limited</code> (the entity is visible to limited accounts only), or
         *        <code>Restricted</code> (the entity was published and then unpublished and only existing buyers can
         *        view it).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(String visibility);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String entityType;

        private String entityId;

        private String entityArn;

        private String lastModifiedDate;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            name(model.name);
            entityType(model.entityType);
            entityId(model.entityId);
            entityArn(model.entityArn);
            lastModifiedDate(model.lastModifiedDate);
            visibility(model.visibility);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public EntitySummary build() {
            return new EntitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
