/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityResponse extends MarketplaceCatalogResponse implements
        ToCopyableBuilder<DescribeEntityResponse.Builder, DescribeEntityResponse> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(DescribeEntityResponse::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityIdentifier").getter(getter(DescribeEntityResponse::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(DescribeEntityResponse::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(DescribeEntityResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Details")
            .getter(getter(DescribeEntityResponse::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD,
            ENTITY_IDENTIFIER_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, DETAILS_FIELD));

    private final String entityType;

    private final String entityIdentifier;

    private final String entityArn;

    private final String lastModifiedDate;

    private final String details;

    private DescribeEntityResponse(BuilderImpl builder) {
        super(builder);
        this.entityType = builder.entityType;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.details = builder.details;
    }

    /**
     * <p>
     * The named type of the entity, in the format of <code>EntityType@Version</code>.
     * </p>
     * 
     * @return The named type of the entity, in the format of <code>EntityType@Version</code>.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The identifier of the entity, in the format of <code>EntityId@RevisionId</code>.
     * </p>
     * 
     * @return The identifier of the entity, in the format of <code>EntityId@RevisionId</code>.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The ARN associated to the unique identifier for the entity referenced in this request.
     * </p>
     * 
     * @return The ARN associated to the unique identifier for the entity referenced in this request.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
     * </p>
     * 
     * @return The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * This stringified JSON object includes the details of the entity.
     * </p>
     * 
     * @return This stringified JSON object includes the details of the entity.
     */
    public final String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityResponse)) {
            return false;
        }
        DescribeEntityResponse other = (DescribeEntityResponse) obj;
        return Objects.equals(entityType(), other.entityType()) && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityArn(), other.entityArn()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityResponse").add("EntityType", entityType())
                .add("EntityIdentifier", entityIdentifier()).add("EntityArn", entityArn())
                .add("LastModifiedDate", lastModifiedDate()).add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "EntityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityResponse, T> g) {
        return obj -> g.apply((DescribeEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEntityResponse> {
        /**
         * <p>
         * The named type of the entity, in the format of <code>EntityType@Version</code>.
         * </p>
         * 
         * @param entityType
         *        The named type of the entity, in the format of <code>EntityType@Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The identifier of the entity, in the format of <code>EntityId@RevisionId</code>.
         * </p>
         * 
         * @param entityIdentifier
         *        The identifier of the entity, in the format of <code>EntityId@RevisionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The ARN associated to the unique identifier for the entity referenced in this request.
         * </p>
         * 
         * @param entityArn
         *        The ARN associated to the unique identifier for the entity referenced in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
         * </p>
         * 
         * @param lastModifiedDate
         *        The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * This stringified JSON object includes the details of the entity.
         * </p>
         * 
         * @param details
         *        This stringified JSON object includes the details of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl extends MarketplaceCatalogResponse.BuilderImpl implements Builder {
        private String entityType;

        private String entityIdentifier;

        private String entityArn;

        private String lastModifiedDate;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityResponse model) {
            super(model);
            entityType(model.entityType);
            entityIdentifier(model.entityIdentifier);
            entityArn(model.entityArn);
            lastModifiedDate(model.lastModifiedDate);
            details(model.details);
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        @Override
        public DescribeEntityResponse build() {
            return new DescribeEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
