/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChangeSetResponse extends MarketplaceCatalogResponse implements
        ToCopyableBuilder<DescribeChangeSetResponse.Builder, DescribeChangeSetResponse> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetId").getter(getter(DescribeChangeSetResponse::changeSetId))
            .setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()).build();

    private static final SdkField<String> CHANGE_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetArn").getter(getter(DescribeChangeSetResponse::changeSetArn))
            .setter(setter(Builder::changeSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetArn").build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(DescribeChangeSetResponse::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(DescribeChangeSetResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(DescribeChangeSetResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeChangeSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(DescribeChangeSetResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureDescription").getter(getter(DescribeChangeSetResponse::failureDescription))
            .setter(setter(Builder::failureDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build())
            .build();

    private static final SdkField<List<ChangeSummary>> CHANGE_SET_FIELD = SdkField
            .<List<ChangeSummary>> builder(MarshallingType.LIST)
            .memberName("ChangeSet")
            .getter(getter(DescribeChangeSetResponse::changeSet))
            .setter(setter(Builder::changeSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD,
            CHANGE_SET_ARN_FIELD, CHANGE_SET_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, FAILURE_CODE_FIELD,
            FAILURE_DESCRIPTION_FIELD, CHANGE_SET_FIELD));

    private final String changeSetId;

    private final String changeSetArn;

    private final String changeSetName;

    private final String startTime;

    private final String endTime;

    private final String status;

    private final String failureCode;

    private final String failureDescription;

    private final List<ChangeSummary> changeSet;

    private DescribeChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.changeSetId = builder.changeSetId;
        this.changeSetArn = builder.changeSetArn;
        this.changeSetName = builder.changeSetName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.failureCode = builder.failureCode;
        this.failureDescription = builder.failureDescription;
        this.changeSet = builder.changeSet;
    }

    /**
     * <p>
     * Required. The unique identifier for the change set referenced in this request.
     * </p>
     * 
     * @return Required. The unique identifier for the change set referenced in this request.
     */
    public final String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The ARN associated with the unique identifier for the change set referenced in this request.
     * </p>
     * 
     * @return The ARN associated with the unique identifier for the change set referenced in this request.
     */
    public final String changeSetArn() {
        return changeSetArn;
    }

    /**
     * <p>
     * The optional name provided in the <code>StartChangeSet</code> request. If you do not provide a name, one is set
     * by default.
     * </p>
     * 
     * @return The optional name provided in the <code>StartChangeSet</code> request. If you do not provide a name, one
     *         is set by default.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request started.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request transitioned to a terminal state. The
     * change cannot transition to a different state. Null if the request is not in a terminal state.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request transitioned to a terminal
     *         state. The change cannot transition to a different state. Null if the request is not in a terminal state.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the change request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the change request.
     * @see ChangeStatus
     */
    public final ChangeStatus status() {
        return ChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the change request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the change request.
     * @see ChangeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means
     * that there are issues with the request (see the <code>ErrorDetailList</code>), or <code>SERVER_FAULT</code>,
     * which means that there is a problem in the system, and you should retry your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
     *         which means that there are issues with the request (see the <code>ErrorDetailList</code>), or
     *         <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
     *         request.
     * @see FailureCode
     */
    public final FailureCode failureCode() {
        return FailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means
     * that there are issues with the request (see the <code>ErrorDetailList</code>), or <code>SERVER_FAULT</code>,
     * which means that there is a problem in the system, and you should retry your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
     *         which means that there are issues with the request (see the <code>ErrorDetailList</code>), or
     *         <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
     *         request.
     * @see FailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * Returned if there is a failure on the change set, but that failure is not related to any of the changes in the
     * request.
     * </p>
     * 
     * @return Returned if there is a failure on the change set, but that failure is not related to any of the changes
     *         in the request.
     */
    public final String failureDescription() {
        return failureDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChangeSet() {
        return changeSet != null && !(changeSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ChangeSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeSet} method.
     * </p>
     * 
     * @return An array of <code>ChangeSummary</code> objects.
     */
    public final List<ChangeSummary> changeSet() {
        return changeSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeSet() ? changeSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetResponse)) {
            return false;
        }
        DescribeChangeSetResponse other = (DescribeChangeSetResponse) obj;
        return Objects.equals(changeSetId(), other.changeSetId()) && Objects.equals(changeSetArn(), other.changeSetArn())
                && Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureDescription(), other.failureDescription()) && hasChangeSet() == other.hasChangeSet()
                && Objects.equals(changeSet(), other.changeSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChangeSetResponse").add("ChangeSetId", changeSetId())
                .add("ChangeSetArn", changeSetArn()).add("ChangeSetName", changeSetName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Status", statusAsString()).add("FailureCode", failureCodeAsString())
                .add("FailureDescription", failureDescription()).add("ChangeSet", hasChangeSet() ? changeSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "ChangeSetArn":
            return Optional.ofNullable(clazz.cast(changeSetArn()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "FailureDescription":
            return Optional.ofNullable(clazz.cast(failureDescription()));
        case "ChangeSet":
            return Optional.ofNullable(clazz.cast(changeSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChangeSetResponse, T> g) {
        return obj -> g.apply((DescribeChangeSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChangeSetResponse> {
        /**
         * <p>
         * Required. The unique identifier for the change set referenced in this request.
         * </p>
         * 
         * @param changeSetId
         *        Required. The unique identifier for the change set referenced in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The ARN associated with the unique identifier for the change set referenced in this request.
         * </p>
         * 
         * @param changeSetArn
         *        The ARN associated with the unique identifier for the change set referenced in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetArn(String changeSetArn);

        /**
         * <p>
         * The optional name provided in the <code>StartChangeSet</code> request. If you do not provide a name, one is
         * set by default.
         * </p>
         * 
         * @param changeSetName
         *        The optional name provided in the <code>StartChangeSet</code> request. If you do not provide a name,
         *        one is set by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request started.
         * </p>
         * 
         * @param startTime
         *        The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request transitioned to a terminal state.
         * The change cannot transition to a different state. Null if the request is not in a terminal state.
         * </p>
         * 
         * @param endTime
         *        The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request transitioned to a terminal
         *        state. The change cannot transition to a different state. Null if the request is not in a terminal
         *        state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The status of the change request.
         * </p>
         * 
         * @param status
         *        The status of the change request.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the change request.
         * </p>
         * 
         * @param status
         *        The status of the change request.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which
         * means that there are issues with the request (see the <code>ErrorDetailList</code>), or
         * <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
         * request.
         * </p>
         * 
         * @param failureCode
         *        Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
         *        which means that there are issues with the request (see the <code>ErrorDetailList</code>), or
         *        <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry
         *        your request.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which
         * means that there are issues with the request (see the <code>ErrorDetailList</code>), or
         * <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your
         * request.
         * </p>
         * 
         * @param failureCode
         *        Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>,
         *        which means that there are issues with the request (see the <code>ErrorDetailList</code>), or
         *        <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry
         *        your request.
         * @see FailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureCode
         */
        Builder failureCode(FailureCode failureCode);

        /**
         * <p>
         * Returned if there is a failure on the change set, but that failure is not related to any of the changes in
         * the request.
         * </p>
         * 
         * @param failureDescription
         *        Returned if there is a failure on the change set, but that failure is not related to any of the
         *        changes in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDescription(String failureDescription);

        /**
         * <p>
         * An array of <code>ChangeSummary</code> objects.
         * </p>
         * 
         * @param changeSet
         *        An array of <code>ChangeSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSet(Collection<ChangeSummary> changeSet);

        /**
         * <p>
         * An array of <code>ChangeSummary</code> objects.
         * </p>
         * 
         * @param changeSet
         *        An array of <code>ChangeSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSet(ChangeSummary... changeSet);

        /**
         * <p>
         * An array of <code>ChangeSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ChangeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ChangeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ChangeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #changeSet(List<ChangeSummary>)}.
         * 
         * @param changeSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ChangeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeSet(java.util.Collection<ChangeSummary>)
         */
        Builder changeSet(Consumer<ChangeSummary.Builder>... changeSet);
    }

    static final class BuilderImpl extends MarketplaceCatalogResponse.BuilderImpl implements Builder {
        private String changeSetId;

        private String changeSetArn;

        private String changeSetName;

        private String startTime;

        private String endTime;

        private String status;

        private String failureCode;

        private String failureDescription;

        private List<ChangeSummary> changeSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetResponse model) {
            super(model);
            changeSetId(model.changeSetId);
            changeSetArn(model.changeSetArn);
            changeSetName(model.changeSetName);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            failureCode(model.failureCode);
            failureDescription(model.failureDescription);
            changeSet(model.changeSet);
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetArn() {
            return changeSetArn;
        }

        public final void setChangeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
        }

        @Override
        public final Builder changeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
            return this;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureDescription() {
            return failureDescription;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final List<ChangeSummary.Builder> getChangeSet() {
            List<ChangeSummary.Builder> result = ChangeSetDescriptionCopier.copyToBuilder(this.changeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSet(Collection<ChangeSummary.BuilderImpl> changeSet) {
            this.changeSet = ChangeSetDescriptionCopier.copyFromBuilder(changeSet);
        }

        @Override
        public final Builder changeSet(Collection<ChangeSummary> changeSet) {
            this.changeSet = ChangeSetDescriptionCopier.copy(changeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(ChangeSummary... changeSet) {
            changeSet(Arrays.asList(changeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Consumer<ChangeSummary.Builder>... changeSet) {
            changeSet(Stream.of(changeSet).map(c -> ChangeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeChangeSetResponse build() {
            return new DescribeChangeSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
