/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object is a container for common summary information about the change. The summary doesn't contain the whole
 * change structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSummary implements SdkPojo, Serializable, ToCopyableBuilder<ChangeSummary.Builder, ChangeSummary> {
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeType").getter(getter(ChangeSummary::changeType)).setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()).build();

    private static final SdkField<Entity> ENTITY_FIELD = SdkField.<Entity> builder(MarshallingType.SDK_POJO).memberName("Entity")
            .getter(getter(ChangeSummary::entity)).setter(setter(Builder::entity)).constructor(Entity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Details")
            .getter(getter(ChangeSummary::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<List<ErrorDetail>> ERROR_DETAIL_LIST_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .memberName("ErrorDetailList")
            .getter(getter(ChangeSummary::errorDetailList))
            .setter(setter(Builder::errorDetailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeName").getter(getter(ChangeSummary::changeName)).setter(setter(Builder::changeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_FIELD,
            ENTITY_FIELD, DETAILS_FIELD, ERROR_DETAIL_LIST_FIELD, CHANGE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changeType;

    private final Entity entity;

    private final String details;

    private final List<ErrorDetail> errorDetailList;

    private final String changeName;

    private ChangeSummary(BuilderImpl builder) {
        this.changeType = builder.changeType;
        this.entity = builder.entity;
        this.details = builder.details;
        this.errorDetailList = builder.errorDetailList;
        this.changeName = builder.changeName;
    }

    /**
     * <p>
     * The type of the change.
     * </p>
     * 
     * @return The type of the change.
     */
    public final String changeType() {
        return changeType;
    }

    /**
     * <p>
     * The entity to be changed.
     * </p>
     * 
     * @return The entity to be changed.
     */
    public final Entity entity() {
        return entity;
    }

    /**
     * <p>
     * This object contains details specific to the change type of the requested change.
     * </p>
     * 
     * @return This object contains details specific to the change type of the requested change.
     */
    public final String details() {
        return details;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorDetailList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorDetailList() {
        return errorDetailList != null && !(errorDetailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ErrorDetail</code> objects associated with the change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorDetailList} method.
     * </p>
     * 
     * @return An array of <code>ErrorDetail</code> objects associated with the change.
     */
    public final List<ErrorDetail> errorDetailList() {
        return errorDetailList;
    }

    /**
     * <p>
     * Optional name for the change.
     * </p>
     * 
     * @return Optional name for the change.
     */
    public final String changeName() {
        return changeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeType());
        hashCode = 31 * hashCode + Objects.hashCode(entity());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorDetailList() ? errorDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSummary)) {
            return false;
        }
        ChangeSummary other = (ChangeSummary) obj;
        return Objects.equals(changeType(), other.changeType()) && Objects.equals(entity(), other.entity())
                && Objects.equals(details(), other.details()) && hasErrorDetailList() == other.hasErrorDetailList()
                && Objects.equals(errorDetailList(), other.errorDetailList()) && Objects.equals(changeName(), other.changeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSummary").add("ChangeType", changeType()).add("Entity", entity())
                .add("Details", details()).add("ErrorDetailList", hasErrorDetailList() ? errorDetailList() : null)
                .add("ChangeName", changeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeType":
            return Optional.ofNullable(clazz.cast(changeType()));
        case "Entity":
            return Optional.ofNullable(clazz.cast(entity()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "ErrorDetailList":
            return Optional.ofNullable(clazz.cast(errorDetailList()));
        case "ChangeName":
            return Optional.ofNullable(clazz.cast(changeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeSummary, T> g) {
        return obj -> g.apply((ChangeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSummary> {
        /**
         * <p>
         * The type of the change.
         * </p>
         * 
         * @param changeType
         *        The type of the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * The entity to be changed.
         * </p>
         * 
         * @param entity
         *        The entity to be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entity(Entity entity);

        /**
         * <p>
         * The entity to be changed.
         * </p>
         * This is a convenience method that creates an instance of the {@link Entity.Builder} avoiding the need to
         * create one manually via {@link Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Entity.Builder#build()} is called immediately and its result is
         * passed to {@link #entity(Entity)}.
         * 
         * @param entity
         *        a consumer that will call methods on {@link Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entity(Entity)
         */
        default Builder entity(Consumer<Entity.Builder> entity) {
            return entity(Entity.builder().applyMutation(entity).build());
        }

        /**
         * <p>
         * This object contains details specific to the change type of the requested change.
         * </p>
         * 
         * @param details
         *        This object contains details specific to the change type of the requested change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * An array of <code>ErrorDetail</code> objects associated with the change.
         * </p>
         * 
         * @param errorDetailList
         *        An array of <code>ErrorDetail</code> objects associated with the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetailList(Collection<ErrorDetail> errorDetailList);

        /**
         * <p>
         * An array of <code>ErrorDetail</code> objects associated with the change.
         * </p>
         * 
         * @param errorDetailList
         *        An array of <code>ErrorDetail</code> objects associated with the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetailList(ErrorDetail... errorDetailList);

        /**
         * <p>
         * An array of <code>ErrorDetail</code> objects associated with the change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #errorDetailList(List<ErrorDetail>)}.
         * 
         * @param errorDetailList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetailList(java.util.Collection<ErrorDetail>)
         */
        Builder errorDetailList(Consumer<ErrorDetail.Builder>... errorDetailList);

        /**
         * <p>
         * Optional name for the change.
         * </p>
         * 
         * @param changeName
         *        Optional name for the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeName(String changeName);
    }

    static final class BuilderImpl implements Builder {
        private String changeType;

        private Entity entity;

        private String details;

        private List<ErrorDetail> errorDetailList = DefaultSdkAutoConstructList.getInstance();

        private String changeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSummary model) {
            changeType(model.changeType);
            entity(model.entity);
            details(model.details);
            errorDetailList(model.errorDetailList);
            changeName(model.changeName);
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        public final Entity.Builder getEntity() {
            return entity != null ? entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetailList() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.errorDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetailList(Collection<ErrorDetail.BuilderImpl> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copyFromBuilder(errorDetailList);
        }

        @Override
        public final Builder errorDetailList(Collection<ErrorDetail> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copy(errorDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(ErrorDetail... errorDetailList) {
            errorDetailList(Arrays.asList(errorDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(Consumer<ErrorDetail.Builder>... errorDetailList) {
            errorDetailList(Stream.of(errorDetailList).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getChangeName() {
            return changeName;
        }

        public final void setChangeName(String changeName) {
            this.changeName = changeName;
        }

        @Override
        public final Builder changeName(String changeName) {
            this.changeName = changeName;
            return this;
        }

        @Override
        public ChangeSummary build() {
            return new ChangeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
