/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplacecatalog.model.AccessDeniedException;
import software.amazon.awssdk.services.marketplacecatalog.model.CancelChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.CancelChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeEntityRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeEntityResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.InternalServiceException;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogException;
import software.amazon.awssdk.services.marketplacecatalog.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ResourceInUseException;
import software.amazon.awssdk.services.marketplacecatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.marketplacecatalog.model.ResourceNotSupportedException;
import software.amazon.awssdk.services.marketplacecatalog.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.marketplacecatalog.model.StartChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.StartChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.TagResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.TagResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacecatalog.model.UntagResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.UntagResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ValidationException;
import software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable;
import software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable;

/**
 * Service client for accessing AWS Marketplace Catalog. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Catalog API actions allow you to manage your entities through list, describe, and update capabilities. An entity can
 * be a product or an offer on AWS Marketplace.
 * </p>
 * <p>
 * You can automate your entity update process by integrating the AWS Marketplace Catalog API with your AWS Marketplace
 * product build or deployment pipelines. You can also create your own applications on top of the Catalog API to manage
 * your products on AWS Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceCatalogClient extends AwsClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "catalog.marketplace";

    /**
     * <p>
     * Used to cancel an open change request. Must be sent before the status of the request changes to
     * <code>APPLYING</code>, the final stage of completing your change request. You can describe a change during the
     * 60-day request history retention period for API calls.
     * </p>
     *
     * @param cancelChangeSetRequest
     * @return Result of the CancelChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ResourceInUseException
     *         The resource is currently in use.
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.CancelChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelChangeSetResponse cancelChangeSet(CancelChangeSetRequest cancelChangeSetRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ResourceInUseException, ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to cancel an open change request. Must be sent before the status of the request changes to
     * <code>APPLYING</code>, the final stage of completing your change request. You can describe a change during the
     * 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CancelChangeSetRequest#builder()}
     * </p>
     *
     * @param cancelChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link CancelChangeSetRequest.Builder} to create a request.
     * @return Result of the CancelChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ResourceInUseException
     *         The resource is currently in use.
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.CancelChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelChangeSetResponse cancelChangeSet(Consumer<CancelChangeSetRequest.Builder> cancelChangeSetRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ResourceInUseException, ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return cancelChangeSet(CancelChangeSetRequest.builder().applyMutation(cancelChangeSetRequest).build());
    }

    /**
     * <p>
     * Deletes a resource-based policy on an Entity that is identified by its resource ARN.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource-based policy on an Entity that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Provides information about a given change set.
     * </p>
     *
     * @param describeChangeSetRequest
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a given change set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChangeSetRequest.Builder} to create a request.
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetResponse describeChangeSet(Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return describeChangeSet(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns the metadata and content of the entity.
     * </p>
     *
     * @param describeEntityRequest
     * @return Result of the DescribeEntity operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotSupportedException
     *         Currently, the specified resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityResponse describeEntity(DescribeEntityRequest describeEntityRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ResourceNotSupportedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata and content of the entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEntityRequest#builder()}
     * </p>
     *
     * @param describeEntityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntityRequest.Builder} to create a request.
     * @return Result of the DescribeEntity operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotSupportedException
     *         Currently, the specified resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityResponse describeEntity(Consumer<DescribeEntityRequest.Builder> describeEntityRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotSupportedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return describeEntity(DescribeEntityRequest.builder().applyMutation(describeEntityRequest).build());
    }

    /**
     * <p>
     * Gets a resource-based policy of an Entity that is identified by its resource ARN.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a resource-based policy of an Entity that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     *
     * @param listChangeSetsRequest
     * @return Result of the ListChangeSets operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsRequest.Builder} to create a request.
     * @return Result of the ListChangeSets operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsResponse listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return listChangeSets(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client
     *             .listChangeSetsPaginator(request);
     *     for (software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsIterable listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return new ListChangeSetsIterable(this, listChangeSetsRequest);
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client
     *             .listChangeSetsPaginator(request);
     *     for (software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsIterable listChangeSetsPaginator(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return listChangeSetsPaginator(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     *
     * @param listEntitiesRequest
     * @return Result of the ListEntities operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesResponse listEntities(ListEntitiesRequest listEntitiesRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesRequest.Builder} to create a request.
     * @return Result of the ListEntities operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesResponse listEntities(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return listEntities(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client
     *             .listEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesIterable listEntitiesPaginator(ListEntitiesRequest listEntitiesRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        return new ListEntitiesIterable(this, listEntitiesRequest);
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client
     *             .listEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesIterable listEntitiesPaginator(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return listEntitiesPaginator(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists all tags that have been added to a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags that have been added to a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy to an Entity. Examples of an entity include: <code>AmiProduct</code> and
     * <code>ContainerProduct</code>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy to an Entity. Examples of an entity include: <code>AmiProduct</code> and
     * <code>ContainerProduct</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Allows you to request changes for your entities. Within a single <code>ChangeSet</code>, you can't start the same
     * change type against the same entity multiple times. Additionally, when a <code>ChangeSet</code> is running, all
     * the entities targeted by the different changes are locked until the change set has completed (either succeeded,
     * cancelled, or failed). If you try to start a change set containing a change against an entity that is already
     * locked, you will receive a <code>ResourceInUseException</code> error.
     * </p>
     * <p>
     * For example, you can't start the <code>ChangeSet</code> described in the <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples"
     * >example</a> later in this topic because it contains two changes to run the same change type (
     * <code>AddRevisions</code>) against the same entity (<code>entity-id@1</code>).
     * </p>
     * <p>
     * For more information about working with change sets, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">
     * Working with change sets</a>. For information on change types for single-AMI products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products"
     * >Working with single-AMI products</a>. Als, for more information on change types available for container-based
     * products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products"
     * >Working with container products</a>.
     * </p>
     *
     * @param startChangeSetRequest
     * @return Result of the StartChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ResourceInUseException
     *         The resource is currently in use.
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws ServiceQuotaExceededException
     *         The maximum number of open requests per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.StartChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default StartChangeSetResponse startChangeSet(StartChangeSetRequest startChangeSetRequest) throws InternalServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to request changes for your entities. Within a single <code>ChangeSet</code>, you can't start the same
     * change type against the same entity multiple times. Additionally, when a <code>ChangeSet</code> is running, all
     * the entities targeted by the different changes are locked until the change set has completed (either succeeded,
     * cancelled, or failed). If you try to start a change set containing a change against an entity that is already
     * locked, you will receive a <code>ResourceInUseException</code> error.
     * </p>
     * <p>
     * For example, you can't start the <code>ChangeSet</code> described in the <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples"
     * >example</a> later in this topic because it contains two changes to run the same change type (
     * <code>AddRevisions</code>) against the same entity (<code>entity-id@1</code>).
     * </p>
     * <p>
     * For more information about working with change sets, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">
     * Working with change sets</a>. For information on change types for single-AMI products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products"
     * >Working with single-AMI products</a>. Als, for more information on change types available for container-based
     * products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products"
     * >Working with container products</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChangeSetRequest.Builder} avoiding the need to
     * create one manually via {@link StartChangeSetRequest#builder()}
     * </p>
     *
     * @param startChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link StartChangeSetRequest.Builder} to create a request.
     * @return Result of the StartChangeSet operation returned by the service.
     * @throws InternalServiceException
     *         There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     *         </p>
     *         <p>
     *         HTTP status code: 404
     * @throws ResourceInUseException
     *         The resource is currently in use.
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws ServiceQuotaExceededException
     *         The maximum number of open requests per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.StartChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default StartChangeSetResponse startChangeSet(Consumer<StartChangeSetRequest.Builder> startChangeSetRequest)
            throws InternalServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            ResourceInUseException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            MarketplaceCatalogException {
        return startChangeSet(StartChangeSetRequest.builder().applyMutation(startChangeSetRequest).build());
    }

    /**
     * <p>
     * Tags a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, MarketplaceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404
     * @throws InternalServiceException
     *         There was an internal service exception.
     *         </p>
     *         <p>
     *         HTTP status code: 500
     * @throws AccessDeniedException
     *         Access is denied.
     *         </p>
     *         <p>
     *         HTTP status code: 403
     * @throws ValidationException
     *         An error occurred during validation.
     *         </p>
     *         <p>
     *         HTTP status code: 422
     * @throws ThrottlingException
     *         Too many requests.
     *         </p>
     *         <p>
     *         HTTP status code: 429
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceCatalogClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, MarketplaceCatalogException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link MarketplaceCatalogClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceCatalogClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceCatalogClient}.
     */
    static MarketplaceCatalogClientBuilder builder() {
        return new DefaultMarketplaceCatalogClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MarketplaceCatalogServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
