/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies property- and tag-based conditions that define filter criteria for including or excluding S3 buckets from
 * the query results. Exclude conditions take precedence over include conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesBucketCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchResourcesBucketCriteria.Builder, SearchResourcesBucketCriteria> {
    private static final SdkField<SearchResourcesCriteriaBlock> EXCLUDES_FIELD = SdkField
            .<SearchResourcesCriteriaBlock> builder(MarshallingType.SDK_POJO).memberName("excludes")
            .getter(getter(SearchResourcesBucketCriteria::excludes)).setter(setter(Builder::excludes))
            .constructor(SearchResourcesCriteriaBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final SdkField<SearchResourcesCriteriaBlock> INCLUDES_FIELD = SdkField
            .<SearchResourcesCriteriaBlock> builder(MarshallingType.SDK_POJO).memberName("includes")
            .getter(getter(SearchResourcesBucketCriteria::includes)).setter(setter(Builder::includes))
            .constructor(SearchResourcesCriteriaBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXCLUDES_FIELD, INCLUDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final SearchResourcesCriteriaBlock excludes;

    private final SearchResourcesCriteriaBlock includes;

    private SearchResourcesBucketCriteria(BuilderImpl builder) {
        this.excludes = builder.excludes;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which buckets to exclude from the results.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which buckets to exclude from the results.
     */
    public final SearchResourcesCriteriaBlock excludes() {
        return excludes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which buckets to include in the results.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which buckets to include in the results.
     */
    public final SearchResourcesCriteriaBlock includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesBucketCriteria)) {
            return false;
        }
        SearchResourcesBucketCriteria other = (SearchResourcesBucketCriteria) obj;
        return Objects.equals(excludes(), other.excludes()) && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourcesBucketCriteria").add("Excludes", excludes()).add("Includes", includes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesBucketCriteria, T> g) {
        return obj -> g.apply((SearchResourcesBucketCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchResourcesBucketCriteria> {
        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to exclude from the results.
         * </p>
         * 
         * @param excludes
         *        The property- and tag-based conditions that determine which buckets to exclude from the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(SearchResourcesCriteriaBlock excludes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to exclude from the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchResourcesCriteriaBlock.Builder}
         * avoiding the need to create one manually via {@link SearchResourcesCriteriaBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchResourcesCriteriaBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #excludes(SearchResourcesCriteriaBlock)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link SearchResourcesCriteriaBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(SearchResourcesCriteriaBlock)
         */
        default Builder excludes(Consumer<SearchResourcesCriteriaBlock.Builder> excludes) {
            return excludes(SearchResourcesCriteriaBlock.builder().applyMutation(excludes).build());
        }

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to include in the results.
         * </p>
         * 
         * @param includes
         *        The property- and tag-based conditions that determine which buckets to include in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(SearchResourcesCriteriaBlock includes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to include in the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchResourcesCriteriaBlock.Builder}
         * avoiding the need to create one manually via {@link SearchResourcesCriteriaBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchResourcesCriteriaBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #includes(SearchResourcesCriteriaBlock)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link SearchResourcesCriteriaBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(SearchResourcesCriteriaBlock)
         */
        default Builder includes(Consumer<SearchResourcesCriteriaBlock.Builder> includes) {
            return includes(SearchResourcesCriteriaBlock.builder().applyMutation(includes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SearchResourcesCriteriaBlock excludes;

        private SearchResourcesCriteriaBlock includes;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesBucketCriteria model) {
            excludes(model.excludes);
            includes(model.includes);
        }

        public final SearchResourcesCriteriaBlock.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(SearchResourcesCriteriaBlock.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(SearchResourcesCriteriaBlock excludes) {
            this.excludes = excludes;
            return this;
        }

        public final SearchResourcesCriteriaBlock.Builder getIncludes() {
            return includes != null ? includes.toBuilder() : null;
        }

        public final void setIncludes(SearchResourcesCriteriaBlock.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(SearchResourcesCriteriaBlock includes) {
            this.includes = includes;
            return this;
        }

        @Override
        public SearchResourcesBucketCriteria build() {
            return new SearchResourcesBucketCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
