/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a type of sensitive data that was detected by a managed data identifier and produced a
 * sensitive data finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultDetection.Builder, DefaultDetection> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(DefaultDetection::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Occurrences> OCCURRENCES_FIELD = SdkField.<Occurrences> builder(MarshallingType.SDK_POJO)
            .memberName("occurrences").getter(getter(DefaultDetection::occurrences)).setter(setter(Builder::occurrences))
            .constructor(Occurrences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("occurrences").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DefaultDetection::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            OCCURRENCES_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final Occurrences occurrences;

    private final String type;

    private DefaultDetection(BuilderImpl builder) {
        this.count = builder.count;
        this.occurrences = builder.occurrences;
        this.type = builder.type;
    }

    /**
     * <p>
     * The total number of occurrences of the type of sensitive data that was detected.
     * </p>
     * 
     * @return The total number of occurrences of the type of sensitive data that was detected.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a
     * maximum of 15 occurrences of sensitive data.
     * </p>
     * 
     * @return The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location
     *         data for a maximum of 15 occurrences of sensitive data.
     */
    public final Occurrences occurrences() {
        return occurrences;
    }

    /**
     * <p>
     * The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.
     * </p>
     * 
     * @return The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(occurrences());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultDetection)) {
            return false;
        }
        DefaultDetection other = (DefaultDetection) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(occurrences(), other.occurrences())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultDetection").add("Count", count()).add("Occurrences", occurrences()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "occurrences":
            return Optional.ofNullable(clazz.cast(occurrences()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultDetection, T> g) {
        return obj -> g.apply((DefaultDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultDetection> {
        /**
         * <p>
         * The total number of occurrences of the type of sensitive data that was detected.
         * </p>
         * 
         * @param count
         *        The total number of occurrences of the type of sensitive data that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data
         * for a maximum of 15 occurrences of sensitive data.
         * </p>
         * 
         * @param occurrences
         *        The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location
         *        data for a maximum of 15 occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrences(Occurrences occurrences);

        /**
         * <p>
         * The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data
         * for a maximum of 15 occurrences of sensitive data.
         * </p>
         * This is a convenience method that creates an instance of the {@link Occurrences.Builder} avoiding the need to
         * create one manually via {@link Occurrences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Occurrences.Builder#build()} is called immediately and its result
         * is passed to {@link #occurrences(Occurrences)}.
         * 
         * @param occurrences
         *        a consumer that will call methods on {@link Occurrences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #occurrences(Occurrences)
         */
        default Builder occurrences(Consumer<Occurrences.Builder> occurrences) {
            return occurrences(Occurrences.builder().applyMutation(occurrences).build());
        }

        /**
         * <p>
         * The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.
         * </p>
         * 
         * @param type
         *        The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private Occurrences occurrences;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultDetection model) {
            count(model.count);
            occurrences(model.occurrences);
            type(model.type);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Occurrences.Builder getOccurrences() {
            return occurrences != null ? occurrences.toBuilder() : null;
        }

        public final void setOccurrences(Occurrences.BuilderImpl occurrences) {
            this.occurrences = occurrences != null ? occurrences.build() : null;
        }

        @Override
        public final Builder occurrences(Occurrences occurrences) {
            this.occurrences = occurrences;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public DefaultDetection build() {
            return new DefaultDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
