/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.BucketMetadata;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;

public class DescribeBucketsIterable
implements SdkIterable<DescribeBucketsResponse> {
    private final Macie2Client client;
    private final DescribeBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBucketsIterable(Macie2Client client, DescribeBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBucketsResponseFetcher();
    }

    public Iterator<DescribeBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BucketMetadata> buckets() {
        Function<DescribeBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.buckets() != null) {
                return response.buckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBucketsResponseFetcher
    implements SyncPageFetcher<DescribeBucketsResponse> {
        private DescribeBucketsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBucketsResponse nextPage(DescribeBucketsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBucketsIterable.this.client.describeBuckets(DescribeBucketsIterable.this.firstRequest);
            }
            return DescribeBucketsIterable.this.client.describeBuckets((DescribeBucketsRequest)((Object)DescribeBucketsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

