/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.FindingCriteria;
import software.amazon.awssdk.services.macie2.model.FindingsFilterAction;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFindingsFilterRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateFindingsFilterRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::actionAsString)).setter(UpdateFindingsFilterRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::description)).setter(UpdateFindingsFilterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("findingCriteria").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::findingCriteria)).setter(UpdateFindingsFilterRequest.setter(Builder::findingCriteria)).constructor(FindingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::id)).setter(UpdateFindingsFilterRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::name)).setter(UpdateFindingsFilterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("position").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::position)).setter(UpdateFindingsFilterRequest.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateFindingsFilterRequest.getter(UpdateFindingsFilterRequest::clientToken)).setter(UpdateFindingsFilterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, DESCRIPTION_FIELD, FINDING_CRITERIA_FIELD, ID_FIELD, NAME_FIELD, POSITION_FIELD, CLIENT_TOKEN_FIELD));
    private final String action;
    private final String description;
    private final FindingCriteria findingCriteria;
    private final String id;
    private final String name;
    private final Integer position;
    private final String clientToken;

    private UpdateFindingsFilterRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.description = builder.description;
        this.findingCriteria = builder.findingCriteria;
        this.id = builder.id;
        this.name = builder.name;
        this.position = builder.position;
        this.clientToken = builder.clientToken;
    }

    public final FindingsFilterAction action() {
        return FindingsFilterAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String description() {
        return this.description;
    }

    public final FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Integer position() {
        return this.position;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsFilterRequest)) {
            return false;
        }
        UpdateFindingsFilterRequest other = (UpdateFindingsFilterRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFindingsFilterRequest").add("Action", (Object)this.actionAsString()).add("Description", (Object)this.description()).add("FindingCriteria", (Object)this.findingCriteria()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Position", (Object)this.position()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "findingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsFilterRequest, T> g) {
        return obj -> g.apply((UpdateFindingsFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String action;
        private String description;
        private FindingCriteria findingCriteria;
        private String id;
        private String name;
        private Integer position;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsFilterRequest model) {
            super(model);
            this.action(model.action);
            this.description(model.description);
            this.findingCriteria(model.findingCriteria);
            this.id(model.id);
            this.name(model.name);
            this.position(model.position);
            this.clientToken(model.clientToken);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FindingsFilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPosition() {
            return this.position;
        }

        public final void setPosition(Integer position) {
            this.position = position;
        }

        @Override
        public final Builder position(Integer position) {
            this.position = position;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsFilterRequest build() {
            return new UpdateFindingsFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFindingsFilterRequest> {
        public Builder action(String var1);

        public Builder action(FindingsFilterAction var1);

        public Builder description(String var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder position(Integer var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

