/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.BatchJobDefinition;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse;

public class ListBatchJobDefinitionsPublisher
implements SdkPublisher<ListBatchJobDefinitionsResponse> {
    private final M2AsyncClient client;
    private final ListBatchJobDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBatchJobDefinitionsPublisher(M2AsyncClient client, ListBatchJobDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBatchJobDefinitionsPublisher(M2AsyncClient client, ListBatchJobDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBatchJobDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBatchJobDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BatchJobDefinition> batchJobDefinitions() {
        Function<ListBatchJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchJobDefinitions() != null) {
                return response.batchJobDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBatchJobDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBatchJobDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListBatchJobDefinitionsResponse> {
        private ListBatchJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBatchJobDefinitionsResponse> nextPage(ListBatchJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchJobDefinitionsPublisher.this.client.listBatchJobDefinitions(ListBatchJobDefinitionsPublisher.this.firstRequest);
            }
            return ListBatchJobDefinitionsPublisher.this.client.listBatchJobDefinitions((ListBatchJobDefinitionsRequest)((Object)ListBatchJobDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

