/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.EfsStorageConfiguration;
import software.amazon.awssdk.services.m2.model.FsxStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageConfiguration> {
    private static final SdkField<EfsStorageConfiguration> EFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("efs").getter(StorageConfiguration.getter(StorageConfiguration::efs)).setter(StorageConfiguration.setter(Builder::efs)).constructor(EfsStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efs").build()}).build();
    private static final SdkField<FsxStorageConfiguration> FSX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fsx").getter(StorageConfiguration.getter(StorageConfiguration::fsx)).setter(StorageConfiguration.setter(Builder::fsx)).constructor(FsxStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fsx").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FIELD, FSX_FIELD));
    private static final long serialVersionUID = 1L;
    private final EfsStorageConfiguration efs;
    private final FsxStorageConfiguration fsx;
    private final Type type;

    private StorageConfiguration(BuilderImpl builder) {
        this.efs = builder.efs;
        this.fsx = builder.fsx;
        this.type = builder.type;
    }

    public final EfsStorageConfiguration efs() {
        return this.efs;
    }

    public final FsxStorageConfiguration fsx() {
        return this.fsx;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.efs());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsx());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration)obj;
        return Objects.equals(this.efs(), other.efs()) && Objects.equals(this.fsx(), other.fsx());
    }

    public final String toString() {
        return ToString.builder((String)"StorageConfiguration").add("Efs", (Object)this.efs()).add("Fsx", (Object)this.fsx()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "efs": {
                return Optional.ofNullable(clazz.cast(this.efs()));
            }
            case "fsx": {
                return Optional.ofNullable(clazz.cast(this.fsx()));
            }
        }
        return Optional.empty();
    }

    public static StorageConfiguration fromEfs(EfsStorageConfiguration efs) {
        return (StorageConfiguration)StorageConfiguration.builder().efs(efs).build();
    }

    public static StorageConfiguration fromEfs(Consumer<EfsStorageConfiguration.Builder> efs) {
        EfsStorageConfiguration.Builder builder = EfsStorageConfiguration.builder();
        efs.accept(builder);
        return StorageConfiguration.fromEfs((EfsStorageConfiguration)builder.build());
    }

    public static StorageConfiguration fromFsx(FsxStorageConfiguration fsx) {
        return (StorageConfiguration)StorageConfiguration.builder().fsx(fsx).build();
    }

    public static StorageConfiguration fromFsx(Consumer<FsxStorageConfiguration.Builder> fsx) {
        FsxStorageConfiguration.Builder builder = FsxStorageConfiguration.builder();
        fsx.accept(builder);
        return StorageConfiguration.fromFsx((FsxStorageConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageConfiguration, T> g) {
        return obj -> g.apply((StorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EFS,
        FSX,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EfsStorageConfiguration efs;
        private FsxStorageConfiguration fsx;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfiguration model) {
            this.efs(model.efs);
            this.fsx(model.fsx);
        }

        public final EfsStorageConfiguration.Builder getEfs() {
            return this.efs != null ? this.efs.toBuilder() : null;
        }

        public final void setEfs(EfsStorageConfiguration.BuilderImpl efs) {
            EfsStorageConfiguration oldValue = this.efs;
            this.efs = efs != null ? efs.build() : null;
            this.handleUnionValueChange(Type.EFS, oldValue, this.efs);
        }

        @Override
        public final Builder efs(EfsStorageConfiguration efs) {
            EfsStorageConfiguration oldValue = this.efs;
            this.efs = efs;
            this.handleUnionValueChange(Type.EFS, oldValue, this.efs);
            return this;
        }

        public final FsxStorageConfiguration.Builder getFsx() {
            return this.fsx != null ? this.fsx.toBuilder() : null;
        }

        public final void setFsx(FsxStorageConfiguration.BuilderImpl fsx) {
            FsxStorageConfiguration oldValue = this.fsx;
            this.fsx = fsx != null ? fsx.build() : null;
            this.handleUnionValueChange(Type.FSX, oldValue, this.fsx);
        }

        @Override
        public final Builder fsx(FsxStorageConfiguration fsx) {
            FsxStorageConfiguration oldValue = this.fsx;
            this.fsx = fsx;
            this.handleUnionValueChange(Type.FSX, oldValue, this.fsx);
            return this;
        }

        public StorageConfiguration build() {
            return new StorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageConfiguration> {
        public Builder efs(EfsStorageConfiguration var1);

        default public Builder efs(Consumer<EfsStorageConfiguration.Builder> efs) {
            return this.efs((EfsStorageConfiguration)((EfsStorageConfiguration.Builder)EfsStorageConfiguration.builder().applyMutation(efs)).build());
        }

        public Builder fsx(FsxStorageConfiguration var1);

        default public Builder fsx(Consumer<FsxStorageConfiguration.Builder> fsx) {
            return this.fsx((FsxStorageConfiguration)((FsxStorageConfiguration.Builder)FsxStorageConfiguration.builder().applyMutation(fsx)).build());
        }
    }
}

