/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the pixels in an anomaly mask. For more information, see <a>Anomaly</a>. <code>PixelAnomaly</code>
 * is only returned by image segmentation models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PixelAnomaly implements SdkPojo, Serializable, ToCopyableBuilder<PixelAnomaly.Builder, PixelAnomaly> {
    private static final SdkField<Float> TOTAL_PERCENTAGE_AREA_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("TotalPercentageArea").getter(getter(PixelAnomaly::totalPercentageArea))
            .setter(setter(Builder::totalPercentageArea))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPercentageArea").build())
            .build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(PixelAnomaly::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_PERCENTAGE_AREA_FIELD,
            COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float totalPercentageArea;

    private final String color;

    private PixelAnomaly(BuilderImpl builder) {
        this.totalPercentageArea = builder.totalPercentageArea;
        this.color = builder.color;
    }

    /**
     * <p>
     * The percentage area of the image that the anomaly type covers.
     * </p>
     * 
     * @return The percentage area of the image that the anomaly type covers.
     */
    public final Float totalPercentageArea() {
        return totalPercentageArea;
    }

    /**
     * <p>
     * A hex color value for the mask that covers an anomaly type. Each anomaly type has a different mask color. The
     * color maps to the color of the anomaly type used in the training dataset.
     * </p>
     * 
     * @return A hex color value for the mask that covers an anomaly type. Each anomaly type has a different mask color.
     *         The color maps to the color of the anomaly type used in the training dataset.
     */
    public final String color() {
        return color;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalPercentageArea());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PixelAnomaly)) {
            return false;
        }
        PixelAnomaly other = (PixelAnomaly) obj;
        return Objects.equals(totalPercentageArea(), other.totalPercentageArea()) && Objects.equals(color(), other.color());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PixelAnomaly").add("TotalPercentageArea", totalPercentageArea()).add("Color", color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalPercentageArea":
            return Optional.ofNullable(clazz.cast(totalPercentageArea()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PixelAnomaly, T> g) {
        return obj -> g.apply((PixelAnomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PixelAnomaly> {
        /**
         * <p>
         * The percentage area of the image that the anomaly type covers.
         * </p>
         * 
         * @param totalPercentageArea
         *        The percentage area of the image that the anomaly type covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalPercentageArea(Float totalPercentageArea);

        /**
         * <p>
         * A hex color value for the mask that covers an anomaly type. Each anomaly type has a different mask color. The
         * color maps to the color of the anomaly type used in the training dataset.
         * </p>
         * 
         * @param color
         *        A hex color value for the mask that covers an anomaly type. Each anomaly type has a different mask
         *        color. The color maps to the color of the anomaly type used in the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);
    }

    static final class BuilderImpl implements Builder {
        private Float totalPercentageArea;

        private String color;

        private BuilderImpl() {
        }

        private BuilderImpl(PixelAnomaly model) {
            totalPercentageArea(model.totalPercentageArea);
            color(model.color);
        }

        public final Float getTotalPercentageArea() {
            return totalPercentageArea;
        }

        public final void setTotalPercentageArea(Float totalPercentageArea) {
            this.totalPercentageArea = totalPercentageArea;
        }

        @Override
        public final Builder totalPercentageArea(Float totalPercentageArea) {
            this.totalPercentageArea = totalPercentageArea;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        @Override
        public PixelAnomaly build() {
            return new PixelAnomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
