/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.lookoutvision.DefaultLookoutVisionAsyncClientBuilder;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionAsyncClientBuilder;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.StartModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.StopModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StopModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesPublisher;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsPublisher;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelsPublisher;
import software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsPublisher;

@SdkPublicApi
@ThreadSafe
public interface LookoutVisionAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "lookoutvision";
    public static final String SERVICE_METADATA_ID = "lookoutvision";

    default public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateDatasetResponse> createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest) {
        return this.createDataset((CreateDatasetRequest)((Object)((CreateDatasetRequest.Builder)CreateDatasetRequest.builder().applyMutation(createDatasetRequest)).build()));
    }

    default public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return this.createModel((CreateModelRequest)((Object)((CreateModelRequest.Builder)CreateModelRequest.builder().applyMutation(createModelRequest)).build()));
    }

    default public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return this.createProject((CreateProjectRequest)((Object)((CreateProjectRequest.Builder)CreateProjectRequest.builder().applyMutation(createProjectRequest)).build()));
    }

    default public CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteDatasetResponse> deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) {
        return this.deleteDataset((DeleteDatasetRequest)((Object)((DeleteDatasetRequest.Builder)DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest)).build()));
    }

    default public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return this.deleteModel((DeleteModelRequest)((Object)((DeleteModelRequest.Builder)DeleteModelRequest.builder().applyMutation(deleteModelRequest)).build()));
    }

    default public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return this.deleteProject((DeleteProjectRequest)((Object)((DeleteProjectRequest.Builder)DeleteProjectRequest.builder().applyMutation(deleteProjectRequest)).build()));
    }

    default public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeDatasetResponse> describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest) {
        return this.describeDataset((DescribeDatasetRequest)((Object)((DescribeDatasetRequest.Builder)DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest)).build()));
    }

    default public CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeModelResponse> describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest) {
        return this.describeModel((DescribeModelRequest)((Object)((DescribeModelRequest.Builder)DescribeModelRequest.builder().applyMutation(describeModelRequest)).build()));
    }

    default public CompletableFuture<DescribeModelPackagingJobResponse> describeModelPackagingJob(DescribeModelPackagingJobRequest describeModelPackagingJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeModelPackagingJobResponse> describeModelPackagingJob(Consumer<DescribeModelPackagingJobRequest.Builder> describeModelPackagingJobRequest) {
        return this.describeModelPackagingJob((DescribeModelPackagingJobRequest)((Object)((DescribeModelPackagingJobRequest.Builder)DescribeModelPackagingJobRequest.builder().applyMutation(describeModelPackagingJobRequest)).build()));
    }

    default public CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeProjectResponse> describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest) {
        return this.describeProject((DescribeProjectRequest)((Object)((DescribeProjectRequest.Builder)DescribeProjectRequest.builder().applyMutation(describeProjectRequest)).build()));
    }

    default public CompletableFuture<DetectAnomaliesResponse> detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DetectAnomaliesResponse> detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest, AsyncRequestBody requestBody) {
        return this.detectAnomalies((DetectAnomaliesRequest)((Object)((DetectAnomaliesRequest.Builder)DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest)).build()), requestBody);
    }

    default public CompletableFuture<DetectAnomaliesResponse> detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, Path sourcePath) {
        return this.detectAnomalies(detectAnomaliesRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<DetectAnomaliesResponse> detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest, Path sourcePath) {
        return this.detectAnomalies((DetectAnomaliesRequest)((Object)((DetectAnomaliesRequest.Builder)DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest)).build()), sourcePath);
    }

    default public CompletableFuture<ListDatasetEntriesResponse> listDatasetEntries(ListDatasetEntriesRequest listDatasetEntriesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDatasetEntriesResponse> listDatasetEntries(Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest) {
        return this.listDatasetEntries((ListDatasetEntriesRequest)((Object)((ListDatasetEntriesRequest.Builder)ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest)).build()));
    }

    default public ListDatasetEntriesPublisher listDatasetEntriesPaginator(ListDatasetEntriesRequest listDatasetEntriesRequest) {
        return new ListDatasetEntriesPublisher(this, listDatasetEntriesRequest);
    }

    default public ListDatasetEntriesPublisher listDatasetEntriesPaginator(Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest) {
        return this.listDatasetEntriesPaginator((ListDatasetEntriesRequest)((Object)((ListDatasetEntriesRequest.Builder)ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest)).build()));
    }

    default public CompletableFuture<ListModelPackagingJobsResponse> listModelPackagingJobs(ListModelPackagingJobsRequest listModelPackagingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListModelPackagingJobsResponse> listModelPackagingJobs(Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) {
        return this.listModelPackagingJobs((ListModelPackagingJobsRequest)((Object)((ListModelPackagingJobsRequest.Builder)ListModelPackagingJobsRequest.builder().applyMutation(listModelPackagingJobsRequest)).build()));
    }

    default public ListModelPackagingJobsPublisher listModelPackagingJobsPaginator(ListModelPackagingJobsRequest listModelPackagingJobsRequest) {
        return new ListModelPackagingJobsPublisher(this, listModelPackagingJobsRequest);
    }

    default public ListModelPackagingJobsPublisher listModelPackagingJobsPaginator(Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) {
        return this.listModelPackagingJobsPaginator((ListModelPackagingJobsRequest)((Object)((ListModelPackagingJobsRequest.Builder)ListModelPackagingJobsRequest.builder().applyMutation(listModelPackagingJobsRequest)).build()));
    }

    default public CompletableFuture<ListModelsResponse> listModels(ListModelsRequest listModelsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListModelsResponse> listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) {
        return this.listModels((ListModelsRequest)((Object)((ListModelsRequest.Builder)ListModelsRequest.builder().applyMutation(listModelsRequest)).build()));
    }

    default public ListModelsPublisher listModelsPaginator(ListModelsRequest listModelsRequest) {
        return new ListModelsPublisher(this, listModelsRequest);
    }

    default public ListModelsPublisher listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest) {
        return this.listModelsPaginator((ListModelsRequest)((Object)((ListModelsRequest.Builder)ListModelsRequest.builder().applyMutation(listModelsRequest)).build()));
    }

    default public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return this.listProjects((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    default public ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return this.listProjectsPaginator((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartModelResponse> startModel(StartModelRequest startModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartModelResponse> startModel(Consumer<StartModelRequest.Builder> startModelRequest) {
        return this.startModel((StartModelRequest)((Object)((StartModelRequest.Builder)StartModelRequest.builder().applyMutation(startModelRequest)).build()));
    }

    default public CompletableFuture<StartModelPackagingJobResponse> startModelPackagingJob(StartModelPackagingJobRequest startModelPackagingJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartModelPackagingJobResponse> startModelPackagingJob(Consumer<StartModelPackagingJobRequest.Builder> startModelPackagingJobRequest) {
        return this.startModelPackagingJob((StartModelPackagingJobRequest)((Object)((StartModelPackagingJobRequest.Builder)StartModelPackagingJobRequest.builder().applyMutation(startModelPackagingJobRequest)).build()));
    }

    default public CompletableFuture<StopModelResponse> stopModel(StopModelRequest stopModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopModelResponse> stopModel(Consumer<StopModelRequest.Builder> stopModelRequest) {
        return this.stopModel((StopModelRequest)((Object)((StopModelRequest.Builder)StopModelRequest.builder().applyMutation(stopModelRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateDatasetEntriesResponse> updateDatasetEntries(UpdateDatasetEntriesRequest updateDatasetEntriesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateDatasetEntriesResponse> updateDatasetEntries(Consumer<UpdateDatasetEntriesRequest.Builder> updateDatasetEntriesRequest) {
        return this.updateDatasetEntries((UpdateDatasetEntriesRequest)((Object)((UpdateDatasetEntriesRequest.Builder)UpdateDatasetEntriesRequest.builder().applyMutation(updateDatasetEntriesRequest)).build()));
    }

    default public LookoutVisionServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static LookoutVisionAsyncClient create() {
        return (LookoutVisionAsyncClient)LookoutVisionAsyncClient.builder().build();
    }

    public static LookoutVisionAsyncClientBuilder builder() {
        return new DefaultLookoutVisionAsyncClientBuilder();
    }
}

