/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestampColumn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestampColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(TimestampColumn.getter(TimestampColumn::columnName)).setter(TimestampColumn.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> COLUMN_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnFormat").getter(TimestampColumn.getter(TimestampColumn::columnFormat)).setter(TimestampColumn.setter(Builder::columnFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, COLUMN_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String columnFormat;

    private TimestampColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnFormat = builder.columnFormat;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String columnFormat() {
        return this.columnFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampColumn)) {
            return false;
        }
        TimestampColumn other = (TimestampColumn)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.columnFormat(), other.columnFormat());
    }

    public final String toString() {
        return ToString.builder((String)"TimestampColumn").add("ColumnName", (Object)this.columnName()).add("ColumnFormat", (Object)this.columnFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "ColumnFormat": {
                return Optional.ofNullable(clazz.cast(this.columnFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampColumn, T> g) {
        return obj -> g.apply((TimestampColumn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String columnFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampColumn model) {
            this.columnName(model.columnName);
            this.columnFormat(model.columnFormat);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnFormat() {
            return this.columnFormat;
        }

        public final void setColumnFormat(String columnFormat) {
            this.columnFormat = columnFormat;
        }

        @Override
        public final Builder columnFormat(String columnFormat) {
            this.columnFormat = columnFormat;
            return this;
        }

        public TimestampColumn build() {
            return new TimestampColumn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestampColumn> {
        public Builder columnName(String var1);

        public Builder columnFormat(String var1);
    }
}

