/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnomalyDetectorRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<UpdateAnomalyDetectorRequest.Builder, UpdateAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(UpdateAnomalyDetectorRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(UpdateAnomalyDetectorRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorDescription")
            .getter(getter(UpdateAnomalyDetectorRequest::anomalyDetectorDescription))
            .setter(setter(Builder::anomalyDetectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build())
            .build();

    private static final SdkField<AnomalyDetectorConfig> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField
            .<AnomalyDetectorConfig> builder(MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig")
            .getter(getter(UpdateAnomalyDetectorRequest::anomalyDetectorConfig)).setter(setter(Builder::anomalyDetectorConfig))
            .constructor(AnomalyDetectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            KMS_KEY_ARN_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD));

    private final String anomalyDetectorArn;

    private final String kmsKeyArn;

    private final String anomalyDetectorDescription;

    private final AnomalyDetectorConfig anomalyDetectorConfig;

    private UpdateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
    }

    /**
     * <p>
     * The ARN of the detector to update.
     * </p>
     * 
     * @return The ARN of the detector to update.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS KMS encryption key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS KMS encryption key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The updated detector description.
     * </p>
     * 
     * @return The updated detector description.
     */
    public final String anomalyDetectorDescription() {
        return anomalyDetectorDescription;
    }

    /**
     * <p>
     * Contains information about the configuration to which the detector will be updated.
     * </p>
     * 
     * @return Contains information about the configuration to which the detector will be updated.
     */
    public final AnomalyDetectorConfig anomalyDetectorConfig() {
        return anomalyDetectorConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalyDetectorRequest)) {
            return false;
        }
        UpdateAnomalyDetectorRequest other = (UpdateAnomalyDetectorRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(anomalyDetectorDescription(), other.anomalyDetectorDescription())
                && Objects.equals(anomalyDetectorConfig(), other.anomalyDetectorConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnomalyDetectorRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("KmsKeyArn", kmsKeyArn()).add("AnomalyDetectorDescription", anomalyDetectorDescription())
                .add("AnomalyDetectorConfig", anomalyDetectorConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "AnomalyDetectorDescription":
            return Optional.ofNullable(clazz.cast(anomalyDetectorDescription()));
        case "AnomalyDetectorConfig":
            return Optional.ofNullable(clazz.cast(anomalyDetectorConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((UpdateAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAnomalyDetectorRequest> {
        /**
         * <p>
         * The ARN of the detector to update.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS KMS encryption key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of an AWS KMS encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The updated detector description.
         * </p>
         * 
         * @param anomalyDetectorDescription
         *        The updated detector description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorDescription(String anomalyDetectorDescription);

        /**
         * <p>
         * Contains information about the configuration to which the detector will be updated.
         * </p>
         * 
         * @param anomalyDetectorConfig
         *        Contains information about the configuration to which the detector will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig);

        /**
         * <p>
         * Contains information about the configuration to which the detector will be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorConfig.Builder} avoiding
         * the need to create one manually via {@link AnomalyDetectorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalyDetectorConfig(AnomalyDetectorConfig)}.
         * 
         * @param anomalyDetectorConfig
         *        a consumer that will call methods on {@link AnomalyDetectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetectorConfig(AnomalyDetectorConfig)
         */
        default Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfig.Builder> anomalyDetectorConfig) {
            return anomalyDetectorConfig(AnomalyDetectorConfig.builder().applyMutation(anomalyDetectorConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String kmsKeyArn;

        private String anomalyDetectorDescription;

        private AnomalyDetectorConfig anomalyDetectorConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalyDetectorRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            kmsKeyArn(model.kmsKeyArn);
            anomalyDetectorDescription(model.anomalyDetectorDescription);
            anomalyDetectorConfig(model.anomalyDetectorConfig);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getAnomalyDetectorDescription() {
            return anomalyDetectorDescription;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final AnomalyDetectorConfig.Builder getAnomalyDetectorConfig() {
            return anomalyDetectorConfig != null ? anomalyDetectorConfig.toBuilder() : null;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfig.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        @Override
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalyDetectorRequest build() {
            return new UpdateAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
