/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the source configuration in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampleDataS3SourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SampleDataS3SourceConfig.Builder, SampleDataS3SourceConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(SampleDataS3SourceConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> TEMPLATED_PATH_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TemplatedPathList")
            .getter(getter(SampleDataS3SourceConfig::templatedPathList))
            .setter(setter(Builder::templatedPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HISTORICAL_DATA_PATH_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HistoricalDataPathList")
            .getter(getter(SampleDataS3SourceConfig::historicalDataPathList))
            .setter(setter(Builder::historicalDataPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalDataPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FileFormatDescriptor> FILE_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<FileFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("FileFormatDescriptor")
            .getter(getter(SampleDataS3SourceConfig::fileFormatDescriptor)).setter(setter(Builder::fileFormatDescriptor))
            .constructor(FileFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormatDescriptor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            TEMPLATED_PATH_LIST_FIELD, HISTORICAL_DATA_PATH_LIST_FIELD, FILE_FORMAT_DESCRIPTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final List<String> templatedPathList;

    private final List<String> historicalDataPathList;

    private final FileFormatDescriptor fileFormatDescriptor;

    private SampleDataS3SourceConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.templatedPathList = builder.templatedPathList;
        this.historicalDataPathList = builder.historicalDataPathList;
        this.fileFormatDescriptor = builder.fileFormatDescriptor;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplatedPathList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplatedPathList() {
        return templatedPathList != null && !(templatedPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings containing the list of templated paths.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplatedPathList} method.
     * </p>
     * 
     * @return An array of strings containing the list of templated paths.
     */
    public final List<String> templatedPathList() {
        return templatedPathList;
    }

    /**
     * For responses, this returns true if the service returned a value for the HistoricalDataPathList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHistoricalDataPathList() {
        return historicalDataPathList != null && !(historicalDataPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings containing the historical set of data paths.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHistoricalDataPathList} method.
     * </p>
     * 
     * @return An array of strings containing the historical set of data paths.
     */
    public final List<String> historicalDataPathList() {
        return historicalDataPathList;
    }

    /**
     * Returns the value of the FileFormatDescriptor property for this object.
     * 
     * @return The value of the FileFormatDescriptor property for this object.
     */
    public final FileFormatDescriptor fileFormatDescriptor() {
        return fileFormatDescriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplatedPathList() ? templatedPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHistoricalDataPathList() ? historicalDataPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatDescriptor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleDataS3SourceConfig)) {
            return false;
        }
        SampleDataS3SourceConfig other = (SampleDataS3SourceConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && hasTemplatedPathList() == other.hasTemplatedPathList()
                && Objects.equals(templatedPathList(), other.templatedPathList())
                && hasHistoricalDataPathList() == other.hasHistoricalDataPathList()
                && Objects.equals(historicalDataPathList(), other.historicalDataPathList())
                && Objects.equals(fileFormatDescriptor(), other.fileFormatDescriptor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampleDataS3SourceConfig").add("RoleArn", roleArn())
                .add("TemplatedPathList", hasTemplatedPathList() ? templatedPathList() : null)
                .add("HistoricalDataPathList", hasHistoricalDataPathList() ? historicalDataPathList() : null)
                .add("FileFormatDescriptor", fileFormatDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "TemplatedPathList":
            return Optional.ofNullable(clazz.cast(templatedPathList()));
        case "HistoricalDataPathList":
            return Optional.ofNullable(clazz.cast(historicalDataPathList()));
        case "FileFormatDescriptor":
            return Optional.ofNullable(clazz.cast(fileFormatDescriptor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampleDataS3SourceConfig, T> g) {
        return obj -> g.apply((SampleDataS3SourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampleDataS3SourceConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of strings containing the list of templated paths.
         * </p>
         * 
         * @param templatedPathList
         *        An array of strings containing the list of templated paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatedPathList(Collection<String> templatedPathList);

        /**
         * <p>
         * An array of strings containing the list of templated paths.
         * </p>
         * 
         * @param templatedPathList
         *        An array of strings containing the list of templated paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatedPathList(String... templatedPathList);

        /**
         * <p>
         * An array of strings containing the historical set of data paths.
         * </p>
         * 
         * @param historicalDataPathList
         *        An array of strings containing the historical set of data paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalDataPathList(Collection<String> historicalDataPathList);

        /**
         * <p>
         * An array of strings containing the historical set of data paths.
         * </p>
         * 
         * @param historicalDataPathList
         *        An array of strings containing the historical set of data paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalDataPathList(String... historicalDataPathList);

        /**
         * Sets the value of the FileFormatDescriptor property for this object.
         *
         * @param fileFormatDescriptor
         *        The new value for the FileFormatDescriptor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormatDescriptor(FileFormatDescriptor fileFormatDescriptor);

        /**
         * Sets the value of the FileFormatDescriptor property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FileFormatDescriptor.Builder} avoiding
         * the need to create one manually via {@link FileFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileFormatDescriptor.Builder#build()} is called immediately and
         * its result is passed to {@link #fileFormatDescriptor(FileFormatDescriptor)}.
         * 
         * @param fileFormatDescriptor
         *        a consumer that will call methods on {@link FileFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileFormatDescriptor(FileFormatDescriptor)
         */
        default Builder fileFormatDescriptor(Consumer<FileFormatDescriptor.Builder> fileFormatDescriptor) {
            return fileFormatDescriptor(FileFormatDescriptor.builder().applyMutation(fileFormatDescriptor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private List<String> templatedPathList = DefaultSdkAutoConstructList.getInstance();

        private List<String> historicalDataPathList = DefaultSdkAutoConstructList.getInstance();

        private FileFormatDescriptor fileFormatDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(SampleDataS3SourceConfig model) {
            roleArn(model.roleArn);
            templatedPathList(model.templatedPathList);
            historicalDataPathList(model.historicalDataPathList);
            fileFormatDescriptor(model.fileFormatDescriptor);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getTemplatedPathList() {
            if (templatedPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return templatedPathList;
        }

        public final void setTemplatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
        }

        @Override
        public final Builder templatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatedPathList(String... templatedPathList) {
            templatedPathList(Arrays.asList(templatedPathList));
            return this;
        }

        public final Collection<String> getHistoricalDataPathList() {
            if (historicalDataPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return historicalDataPathList;
        }

        public final void setHistoricalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
        }

        @Override
        public final Builder historicalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalDataPathList(String... historicalDataPathList) {
            historicalDataPathList(Arrays.asList(historicalDataPathList));
            return this;
        }

        public final FileFormatDescriptor.Builder getFileFormatDescriptor() {
            return fileFormatDescriptor != null ? fileFormatDescriptor.toBuilder() : null;
        }

        public final void setFileFormatDescriptor(FileFormatDescriptor.BuilderImpl fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor != null ? fileFormatDescriptor.build() : null;
        }

        @Override
        public final Builder fileFormatDescriptor(FileFormatDescriptor fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor;
            return this;
        }

        @Override
        public SampleDataS3SourceConfig build() {
            return new SampleDataS3SourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
