/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the SNS topic to which you want to send your alerts and the IAM role that has access to
 * that topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SNSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SNSConfiguration.Builder, SNSConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(SNSConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(SNSConfiguration::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsFormat").getter(getter(SNSConfiguration::snsFormatAsString)).setter(setter(Builder::snsFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            SNS_TOPIC_ARN_FIELD, SNS_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String snsTopicArn;

    private final String snsFormat;

    private SNSConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsFormat = builder.snsFormat;
    }

    /**
     * <p>
     * The ARN of the IAM role that has access to the target SNS topic.
     * </p>
     * 
     * @return The ARN of the IAM role that has access to the target SNS topic.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN of the target SNS topic.
     * </p>
     * 
     * @return The ARN of the target SNS topic.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The format of the SNS topic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a link to
     * the anomaly detail page. We recommend this for email.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend this
     * for SMS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snsFormat} will
     * return {@link SnsFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snsFormatAsString}.
     * </p>
     * 
     * @return The format of the SNS topic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a
     *         link to the anomaly detail page. We recommend this for email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend
     *         this for SMS.
     *         </p>
     *         </li>
     * @see SnsFormat
     */
    public final SnsFormat snsFormat() {
        return SnsFormat.fromValue(snsFormat);
    }

    /**
     * <p>
     * The format of the SNS topic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a link to
     * the anomaly detail page. We recommend this for email.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend this
     * for SMS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snsFormat} will
     * return {@link SnsFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snsFormatAsString}.
     * </p>
     * 
     * @return The format of the SNS topic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a
     *         link to the anomaly detail page. We recommend this for email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend
     *         this for SMS.
     *         </p>
     *         </li>
     * @see SnsFormat
     */
    public final String snsFormatAsString() {
        return snsFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSConfiguration)) {
            return false;
        }
        SNSConfiguration other = (SNSConfiguration) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(snsFormatAsString(), other.snsFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SNSConfiguration").add("RoleArn", roleArn()).add("SnsTopicArn", snsTopicArn())
                .add("SnsFormat", snsFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsFormat":
            return Optional.ofNullable(clazz.cast(snsFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SNSConfiguration, T> g) {
        return obj -> g.apply((SNSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SNSConfiguration> {
        /**
         * <p>
         * The ARN of the IAM role that has access to the target SNS topic.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that has access to the target SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN of the target SNS topic.
         * </p>
         * 
         * @param snsTopicArn
         *        The ARN of the target SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The format of the SNS topic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a link
         * to the anomaly detail page. We recommend this for email.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend
         * this for SMS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snsFormat
         *        The format of the SNS topic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is
         *        the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and
         *        a link to the anomaly detail page. We recommend this for email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We
         *        recommend this for SMS.
         *        </p>
         *        </li>
         * @see SnsFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsFormat
         */
        Builder snsFormat(String snsFormat);

        /**
         * <p>
         * The format of the SNS topic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and a link
         * to the anomaly detail page. We recommend this for email.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We recommend
         * this for SMS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snsFormat
         *        The format of the SNS topic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JSON</code> – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is
         *        the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LONG_TEXT</code> – Send human-readable alerts with information about the impacted timeseries and
         *        a link to the anomaly detail page. We recommend this for email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT_TEXT</code> – Send human-readable alerts with a link to the anomaly detail page. We
         *        recommend this for SMS.
         *        </p>
         *        </li>
         * @see SnsFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsFormat
         */
        Builder snsFormat(SnsFormat snsFormat);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String snsTopicArn;

        private String snsFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSConfiguration model) {
            roleArn(model.roleArn);
            snsTopicArn(model.snsTopicArn);
            snsFormat(model.snsFormat);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsFormat() {
            return snsFormat;
        }

        public final void setSnsFormat(String snsFormat) {
            this.snsFormat = snsFormat;
        }

        @Override
        public final Builder snsFormat(String snsFormat) {
            this.snsFormat = snsFormat;
            return this;
        }

        @Override
        public final Builder snsFormat(SnsFormat snsFormat) {
            this.snsFormat(snsFormat == null ? null : snsFormat.toString());
            return this;
        }

        @Override
        public SNSConfiguration build() {
            return new SNSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
