/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMetricSetRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<CreateMetricSetRequest.Builder, CreateMetricSetRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(CreateMetricSetRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetName").getter(getter(CreateMetricSetRequest::metricSetName))
            .setter(setter(Builder::metricSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()).build();

    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetDescription").getter(getter(CreateMetricSetRequest::metricSetDescription))
            .setter(setter(Builder::metricSetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build())
            .build();

    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField
            .<List<Metric>> builder(MarshallingType.LIST)
            .memberName("MetricList")
            .getter(getter(CreateMetricSetRequest::metricList))
            .setter(setter(Builder::metricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metric> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(CreateMetricSetRequest::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField
            .<TimestampColumn> builder(MarshallingType.SDK_POJO).memberName("TimestampColumn")
            .getter(getter(CreateMetricSetRequest::timestampColumn)).setter(setter(Builder::timestampColumn))
            .constructor(TimestampColumn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()).build();

    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DimensionList")
            .getter(getter(CreateMetricSetRequest::dimensionList))
            .setter(setter(Builder::dimensionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetFrequency").getter(getter(CreateMetricSetRequest::metricSetFrequencyAsString))
            .setter(setter(Builder::metricSetFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build())
            .build();

    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.<MetricSource> builder(MarshallingType.SDK_POJO)
            .memberName("MetricSource").getter(getter(CreateMetricSetRequest::metricSource))
            .setter(setter(Builder::metricSource)).constructor(MetricSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(CreateMetricSetRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateMetricSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<MetricSetDimensionFilter>> DIMENSION_FILTER_LIST_FIELD = SdkField
            .<List<MetricSetDimensionFilter>> builder(MarshallingType.LIST)
            .memberName("DimensionFilterList")
            .getter(getter(CreateMetricSetRequest::dimensionFilterList))
            .setter(setter(Builder::dimensionFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionFilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricSetDimensionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricSetDimensionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            METRIC_SET_NAME_FIELD, METRIC_SET_DESCRIPTION_FIELD, METRIC_LIST_FIELD, OFFSET_FIELD, TIMESTAMP_COLUMN_FIELD,
            DIMENSION_LIST_FIELD, METRIC_SET_FREQUENCY_FIELD, METRIC_SOURCE_FIELD, TIMEZONE_FIELD, TAGS_FIELD,
            DIMENSION_FILTER_LIST_FIELD));

    private final String anomalyDetectorArn;

    private final String metricSetName;

    private final String metricSetDescription;

    private final List<Metric> metricList;

    private final Integer offset;

    private final TimestampColumn timestampColumn;

    private final List<String> dimensionList;

    private final String metricSetFrequency;

    private final MetricSource metricSource;

    private final String timezone;

    private final Map<String, String> tags;

    private final List<MetricSetDimensionFilter> dimensionFilterList;

    private CreateMetricSetRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetName = builder.metricSetName;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricList = builder.metricList;
        this.offset = builder.offset;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.metricSource = builder.metricSource;
        this.timezone = builder.timezone;
        this.tags = builder.tags;
        this.dimensionFilterList = builder.dimensionFilterList;
    }

    /**
     * <p>
     * The ARN of the anomaly detector that will use the dataset.
     * </p>
     * 
     * @return The ARN of the anomaly detector that will use the dataset.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String metricSetName() {
        return metricSetName;
    }

    /**
     * <p>
     * A description of the dataset you are creating.
     * </p>
     * 
     * @return A description of the dataset you are creating.
     */
    public final String metricSetDescription() {
        return metricSetDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetricList() {
        return metricList != null && !(metricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics that the dataset will contain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricList} method.
     * </p>
     * 
     * @return A list of metrics that the dataset will contain.
     */
    public final List<Metric> metricList() {
        return metricList;
    }

    /**
     * <p>
     * After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only
     * supported for S3, Redshift, Athena and datasources.
     * </p>
     * 
     * @return After an interval ends, the amount of seconds that the detector waits before importing data. Offset is
     *         only supported for S3, Redshift, Athena and datasources.
     */
    public final Integer offset() {
        return offset;
    }

    /**
     * <p>
     * Contains information about the column used for tracking time in your source data.
     * </p>
     * 
     * @return Contains information about the column used for tracking time in your source data.
     */
    public final TimestampColumn timestampColumn() {
        return timestampColumn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionList() {
        return dimensionList != null && !(dimensionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the fields you want to treat as dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionList} method.
     * </p>
     * 
     * @return A list of the fields you want to treat as dimensions.
     */
    public final List<String> dimensionList() {
        return dimensionList;
    }

    /**
     * <p>
     * The frequency with which the source data will be analyzed for anomalies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The frequency with which the source data will be analyzed for anomalies.
     * @see Frequency
     */
    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(metricSetFrequency);
    }

    /**
     * <p>
     * The frequency with which the source data will be analyzed for anomalies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The frequency with which the source data will be analyzed for anomalies.
     * @see Frequency
     */
    public final String metricSetFrequencyAsString() {
        return metricSetFrequency;
    }

    /**
     * <p>
     * Contains information about how the source data should be interpreted.
     * </p>
     * 
     * @return Contains information about how the source data should be interpreted.
     */
    public final MetricSource metricSource() {
        return metricSource;
    }

    /**
     * <p>
     * The time zone in which your source data was recorded.
     * </p>
     * 
     * @return The time zone in which your source data was recorded.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply
     * to the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
     *         apply to the dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionFilterList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionFilterList() {
        return dimensionFilterList != null && !(dimensionFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filters that specify which data is kept for anomaly detection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionFilterList} method.
     * </p>
     * 
     * @return A list of filters that specify which data is kept for anomaly detection.
     */
    public final List<MetricSetDimensionFilter> dimensionFilterList() {
        return dimensionFilterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricList() ? metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionList() ? dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricSource());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionFilterList() ? dimensionFilterList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricSetRequest)) {
            return false;
        }
        CreateMetricSetRequest other = (CreateMetricSetRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(metricSetName(), other.metricSetName())
                && Objects.equals(metricSetDescription(), other.metricSetDescription())
                && hasMetricList() == other.hasMetricList() && Objects.equals(metricList(), other.metricList())
                && Objects.equals(offset(), other.offset()) && Objects.equals(timestampColumn(), other.timestampColumn())
                && hasDimensionList() == other.hasDimensionList() && Objects.equals(dimensionList(), other.dimensionList())
                && Objects.equals(metricSetFrequencyAsString(), other.metricSetFrequencyAsString())
                && Objects.equals(metricSource(), other.metricSource()) && Objects.equals(timezone(), other.timezone())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasDimensionFilterList() == other.hasDimensionFilterList()
                && Objects.equals(dimensionFilterList(), other.dimensionFilterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMetricSetRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("MetricSetName", metricSetName()).add("MetricSetDescription", metricSetDescription())
                .add("MetricList", hasMetricList() ? metricList() : null).add("Offset", offset())
                .add("TimestampColumn", timestampColumn()).add("DimensionList", hasDimensionList() ? dimensionList() : null)
                .add("MetricSetFrequency", metricSetFrequencyAsString()).add("MetricSource", metricSource())
                .add("Timezone", timezone()).add("Tags", hasTags() ? tags() : null)
                .add("DimensionFilterList", hasDimensionFilterList() ? dimensionFilterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "MetricSetName":
            return Optional.ofNullable(clazz.cast(metricSetName()));
        case "MetricSetDescription":
            return Optional.ofNullable(clazz.cast(metricSetDescription()));
        case "MetricList":
            return Optional.ofNullable(clazz.cast(metricList()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "TimestampColumn":
            return Optional.ofNullable(clazz.cast(timestampColumn()));
        case "DimensionList":
            return Optional.ofNullable(clazz.cast(dimensionList()));
        case "MetricSetFrequency":
            return Optional.ofNullable(clazz.cast(metricSetFrequencyAsString()));
        case "MetricSource":
            return Optional.ofNullable(clazz.cast(metricSource()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DimensionFilterList":
            return Optional.ofNullable(clazz.cast(dimensionFilterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetricSetRequest, T> g) {
        return obj -> g.apply((CreateMetricSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMetricSetRequest> {
        /**
         * <p>
         * The ARN of the anomaly detector that will use the dataset.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the anomaly detector that will use the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param metricSetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetName(String metricSetName);

        /**
         * <p>
         * A description of the dataset you are creating.
         * </p>
         * 
         * @param metricSetDescription
         *        A description of the dataset you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDescription(String metricSetDescription);

        /**
         * <p>
         * A list of metrics that the dataset will contain.
         * </p>
         * 
         * @param metricList
         *        A list of metrics that the dataset will contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Collection<Metric> metricList);

        /**
         * <p>
         * A list of metrics that the dataset will contain.
         * </p>
         * 
         * @param metricList
         *        A list of metrics that the dataset will contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Metric... metricList);

        /**
         * <p>
         * A list of metrics that the dataset will contain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.Metric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutmetrics.model.Metric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.Metric.Builder#build()} is called immediately and
         * its result is passed to {@link #metricList(List<Metric>)}.
         * 
         * @param metricList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricList(java.util.Collection<Metric>)
         */
        Builder metricList(Consumer<Metric.Builder>... metricList);

        /**
         * <p>
         * After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only
         * supported for S3, Redshift, Athena and datasources.
         * </p>
         * 
         * @param offset
         *        After an interval ends, the amount of seconds that the detector waits before importing data. Offset is
         *        only supported for S3, Redshift, Athena and datasources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * <p>
         * Contains information about the column used for tracking time in your source data.
         * </p>
         * 
         * @param timestampColumn
         *        Contains information about the column used for tracking time in your source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampColumn(TimestampColumn timestampColumn);

        /**
         * <p>
         * Contains information about the column used for tracking time in your source data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestampColumn.Builder} avoiding the
         * need to create one manually via {@link TimestampColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestampColumn.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampColumn(TimestampColumn)}.
         * 
         * @param timestampColumn
         *        a consumer that will call methods on {@link TimestampColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampColumn(TimestampColumn)
         */
        default Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return timestampColumn(TimestampColumn.builder().applyMutation(timestampColumn).build());
        }

        /**
         * <p>
         * A list of the fields you want to treat as dimensions.
         * </p>
         * 
         * @param dimensionList
         *        A list of the fields you want to treat as dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(Collection<String> dimensionList);

        /**
         * <p>
         * A list of the fields you want to treat as dimensions.
         * </p>
         * 
         * @param dimensionList
         *        A list of the fields you want to treat as dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(String... dimensionList);

        /**
         * <p>
         * The frequency with which the source data will be analyzed for anomalies.
         * </p>
         * 
         * @param metricSetFrequency
         *        The frequency with which the source data will be analyzed for anomalies.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(String metricSetFrequency);

        /**
         * <p>
         * The frequency with which the source data will be analyzed for anomalies.
         * </p>
         * 
         * @param metricSetFrequency
         *        The frequency with which the source data will be analyzed for anomalies.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(Frequency metricSetFrequency);

        /**
         * <p>
         * Contains information about how the source data should be interpreted.
         * </p>
         * 
         * @param metricSource
         *        Contains information about how the source data should be interpreted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSource(MetricSource metricSource);

        /**
         * <p>
         * Contains information about how the source data should be interpreted.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricSource.Builder} avoiding the need
         * to create one manually via {@link MetricSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricSource.Builder#build()} is called immediately and its
         * result is passed to {@link #metricSource(MetricSource)}.
         * 
         * @param metricSource
         *        a consumer that will call methods on {@link MetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSource(MetricSource)
         */
        default Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return metricSource(MetricSource.builder().applyMutation(metricSource).build());
        }

        /**
         * <p>
         * The time zone in which your source data was recorded.
         * </p>
         * 
         * @param timezone
         *        The time zone in which your source data was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
         * apply to the dataset.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>
         *        to apply to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of filters that specify which data is kept for anomaly detection.
         * </p>
         * 
         * @param dimensionFilterList
         *        A list of filters that specify which data is kept for anomaly detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionFilterList(Collection<MetricSetDimensionFilter> dimensionFilterList);

        /**
         * <p>
         * A list of filters that specify which data is kept for anomaly detection.
         * </p>
         * 
         * @param dimensionFilterList
         *        A list of filters that specify which data is kept for anomaly detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionFilterList(MetricSetDimensionFilter... dimensionFilterList);

        /**
         * <p>
         * A list of filters that specify which data is kept for anomaly detection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #dimensionFilterList(List<MetricSetDimensionFilter>)}.
         * 
         * @param dimensionFilterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionFilterList(java.util.Collection<MetricSetDimensionFilter>)
         */
        Builder dimensionFilterList(Consumer<MetricSetDimensionFilter.Builder>... dimensionFilterList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String metricSetName;

        private String metricSetDescription;

        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();

        private Integer offset;

        private TimestampColumn timestampColumn;

        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();

        private String metricSetFrequency;

        private MetricSource metricSource;

        private String timezone;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<MetricSetDimensionFilter> dimensionFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetricSetRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            metricSetName(model.metricSetName);
            metricSetDescription(model.metricSetDescription);
            metricList(model.metricList);
            offset(model.offset);
            timestampColumn(model.timestampColumn);
            dimensionList(model.dimensionList);
            metricSetFrequency(model.metricSetFrequency);
            metricSource(model.metricSource);
            timezone(model.timezone);
            tags(model.tags);
            dimensionFilterList(model.dimensionFilterList);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetName() {
            return metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final String getMetricSetDescription() {
            return metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        @Override
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Metric... metricList) {
            metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder>... metricList) {
            metricList(Stream.of(metricList).map(c -> Metric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return timestampColumn != null ? timestampColumn.toBuilder() : null;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        @Override
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final Collection<String> getDimensionList() {
            if (dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionList;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        @Override
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(String... dimensionList) {
            dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final String getMetricSetFrequency() {
            return metricSetFrequency;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        @Override
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final MetricSource.Builder getMetricSource() {
            return metricSource != null ? metricSource.toBuilder() : null;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<MetricSetDimensionFilter.Builder> getDimensionFilterList() {
            List<MetricSetDimensionFilter.Builder> result = MetricSetDimensionFilterListCopier
                    .copyToBuilder(this.dimensionFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionFilterList(Collection<MetricSetDimensionFilter.BuilderImpl> dimensionFilterList) {
            this.dimensionFilterList = MetricSetDimensionFilterListCopier.copyFromBuilder(dimensionFilterList);
        }

        @Override
        public final Builder dimensionFilterList(Collection<MetricSetDimensionFilter> dimensionFilterList) {
            this.dimensionFilterList = MetricSetDimensionFilterListCopier.copy(dimensionFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(MetricSetDimensionFilter... dimensionFilterList) {
            dimensionFilterList(Arrays.asList(dimensionFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(Consumer<MetricSetDimensionFilter.Builder>... dimensionFilterList) {
            dimensionFilterList(Stream.of(dimensionFilterList)
                    .map(c -> MetricSetDimensionFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetricSetRequest build() {
            return new CreateMetricSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
