/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValue implements SdkPojo, Serializable, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S")
            .getter(getter(AttributeValue::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<String> N_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("N")
            .getter(getter(AttributeValue::n)).setter(setter(Builder::n))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()).build();

    private static final SdkField<String> B_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("B")
            .getter(getter(AttributeValue::b)).setter(setter(Builder::b))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()).build();

    private static final SdkField<List<String>> SS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SS")
            .getter(getter(AttributeValue::ss))
            .setter(setter(Builder::ss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NS")
            .getter(getter(AttributeValue::ns))
            .setter(setter(Builder::ns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BS")
            .getter(getter(AttributeValue::bs))
            .setter(setter(Builder::bs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, B_FIELD,
            SS_FIELD, NS_FIELD, BS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s;

    private final String n;

    private final String b;

    private final List<String> ss;

    private final List<String> ns;

    private final List<String> bs;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
    }

    /**
     * <p>
     * A string.
     * </p>
     * 
     * @return A string.
     */
    public final String s() {
        return s;
    }

    /**
     * <p>
     * A number.
     * </p>
     * 
     * @return A number.
     */
    public final String n() {
        return n;
    }

    /**
     * <p>
     * A binary value.
     * </p>
     * 
     * @return A binary value.
     */
    public final String b() {
        return b;
    }

    /**
     * For responses, this returns true if the service returned a value for the SS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSs() {
        return ss != null && !(ss instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSs} method.
     * </p>
     * 
     * @return A list of strings.
     */
    public final List<String> ss() {
        return ss;
    }

    /**
     * For responses, this returns true if the service returned a value for the NS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNs() {
        return ns != null && !(ns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNs} method.
     * </p>
     * 
     * @return A list of numbers.
     */
    public final List<String> ns() {
        return ns;
    }

    /**
     * For responses, this returns true if the service returned a value for the BS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBs() {
        return bs != null && !(bs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of binary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBs} method.
     * </p>
     * 
     * @return A list of binary values.
     */
    public final List<String> bs() {
        return bs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(n());
        hashCode = 31 * hashCode + Objects.hashCode(b());
        hashCode = 31 * hashCode + Objects.hashCode(hasSs() ? ss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNs() ? ns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBs() ? bs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        return Objects.equals(s(), other.s()) && Objects.equals(n(), other.n()) && Objects.equals(b(), other.b())
                && hasSs() == other.hasSs() && Objects.equals(ss(), other.ss()) && hasNs() == other.hasNs()
                && Objects.equals(ns(), other.ns()) && hasBs() == other.hasBs() && Objects.equals(bs(), other.bs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeValue").add("S", s()).add("N", n()).add("B", b()).add("SS", hasSs() ? ss() : null)
                .add("NS", hasNs() ? ns() : null).add("BS", hasBs() ? bs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "N":
            return Optional.ofNullable(clazz.cast(n()));
        case "B":
            return Optional.ofNullable(clazz.cast(b()));
        case "SS":
            return Optional.ofNullable(clazz.cast(ss()));
        case "NS":
            return Optional.ofNullable(clazz.cast(ns()));
        case "BS":
            return Optional.ofNullable(clazz.cast(bs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * A string.
         * </p>
         * 
         * @param s
         *        A string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * A number.
         * </p>
         * 
         * @param n
         *        A number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(String n);

        /**
         * <p>
         * A binary value.
         * </p>
         * 
         * @param b
         *        A binary value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder b(String b);

        /**
         * <p>
         * A list of strings.
         * </p>
         * 
         * @param ss
         *        A list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(Collection<String> ss);

        /**
         * <p>
         * A list of strings.
         * </p>
         * 
         * @param ss
         *        A list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(String... ss);

        /**
         * <p>
         * A list of numbers.
         * </p>
         * 
         * @param ns
         *        A list of numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(Collection<String> ns);

        /**
         * <p>
         * A list of numbers.
         * </p>
         * 
         * @param ns
         *        A list of numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(String... ns);

        /**
         * <p>
         * A list of binary values.
         * </p>
         * 
         * @param bs
         *        A list of binary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(Collection<String> bs);

        /**
         * <p>
         * A list of binary values.
         * </p>
         * 
         * @param bs
         *        A list of binary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(String... bs);
    }

    static final class BuilderImpl implements Builder {
        private String s;

        private String n;

        private String b;

        private List<String> ss = DefaultSdkAutoConstructList.getInstance();

        private List<String> ns = DefaultSdkAutoConstructList.getInstance();

        private List<String> bs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            s(model.s);
            n(model.n);
            b(model.b);
            ss(model.ss);
            ns(model.ns);
            bs(model.bs);
        }

        public final String getS() {
            return s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final String getN() {
            return n;
        }

        public final void setN(String n) {
            this.n = n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final String getB() {
            return b;
        }

        public final void setB(String b) {
            this.b = b;
        }

        @Override
        public final Builder b(String b) {
            this.b = b;
            return this;
        }

        public final Collection<String> getSs() {
            if (ss instanceof SdkAutoConstructList) {
                return null;
            }
            return ss;
        }

        public final void setSs(Collection<String> ss) {
            this.ss = StringListAttributeValueCopier.copy(ss);
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringListAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String... ss) {
            ss(Arrays.asList(ss));
            return this;
        }

        public final Collection<String> getNs() {
            if (ns instanceof SdkAutoConstructList) {
                return null;
            }
            return ns;
        }

        public final void setNs(Collection<String> ns) {
            this.ns = NumberListAttributeValueCopier.copy(ns);
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberListAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String... ns) {
            ns(Arrays.asList(ns));
            return this;
        }

        public final Collection<String> getBs() {
            if (bs instanceof SdkAutoConstructList) {
                return null;
            }
            return bs;
        }

        public final void setBs(Collection<String> bs) {
            this.bs = BinaryListAttributeValueCopier.copy(bs);
        }

        @Override
        public final Builder bs(Collection<String> bs) {
            this.bs = BinaryListAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(String... bs) {
            bs(Arrays.asList(bs));
            return this;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
