/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated statistics for a group of anomalous metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyGroupStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyGroupStatistics.Builder, AnomalyGroupStatistics> {
    private static final SdkField<String> EVALUATION_START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationStartDate").getter(getter(AnomalyGroupStatistics::evaluationStartDate))
            .setter(setter(Builder::evaluationStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartDate").build())
            .build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(AnomalyGroupStatistics::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<List<ItemizedMetricStats>> ITEMIZED_METRIC_STATS_LIST_FIELD = SdkField
            .<List<ItemizedMetricStats>> builder(MarshallingType.LIST)
            .memberName("ItemizedMetricStatsList")
            .getter(getter(AnomalyGroupStatistics::itemizedMetricStatsList))
            .setter(setter(Builder::itemizedMetricStatsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemizedMetricStatsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ItemizedMetricStats> builder(MarshallingType.SDK_POJO)
                                            .constructor(ItemizedMetricStats::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_START_DATE_FIELD,
            TOTAL_COUNT_FIELD, ITEMIZED_METRIC_STATS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String evaluationStartDate;

    private final Integer totalCount;

    private final List<ItemizedMetricStats> itemizedMetricStatsList;

    private AnomalyGroupStatistics(BuilderImpl builder) {
        this.evaluationStartDate = builder.evaluationStartDate;
        this.totalCount = builder.totalCount;
        this.itemizedMetricStatsList = builder.itemizedMetricStatsList;
    }

    /**
     * <p>
     * The start of the time range that was searched.
     * </p>
     * 
     * @return The start of the time range that was searched.
     */
    public final String evaluationStartDate() {
        return evaluationStartDate;
    }

    /**
     * <p>
     * The number of groups found.
     * </p>
     * 
     * @return The number of groups found.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemizedMetricStatsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasItemizedMetricStatsList() {
        return itemizedMetricStatsList != null && !(itemizedMetricStatsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Statistics for individual metrics within the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemizedMetricStatsList} method.
     * </p>
     * 
     * @return Statistics for individual metrics within the group.
     */
    public final List<ItemizedMetricStats> itemizedMetricStatsList() {
        return itemizedMetricStatsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasItemizedMetricStatsList() ? itemizedMetricStatsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupStatistics)) {
            return false;
        }
        AnomalyGroupStatistics other = (AnomalyGroupStatistics) obj;
        return Objects.equals(evaluationStartDate(), other.evaluationStartDate())
                && Objects.equals(totalCount(), other.totalCount())
                && hasItemizedMetricStatsList() == other.hasItemizedMetricStatsList()
                && Objects.equals(itemizedMetricStatsList(), other.itemizedMetricStatsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyGroupStatistics").add("EvaluationStartDate", evaluationStartDate())
                .add("TotalCount", totalCount())
                .add("ItemizedMetricStatsList", hasItemizedMetricStatsList() ? itemizedMetricStatsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationStartDate":
            return Optional.ofNullable(clazz.cast(evaluationStartDate()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "ItemizedMetricStatsList":
            return Optional.ofNullable(clazz.cast(itemizedMetricStatsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupStatistics, T> g) {
        return obj -> g.apply((AnomalyGroupStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyGroupStatistics> {
        /**
         * <p>
         * The start of the time range that was searched.
         * </p>
         * 
         * @param evaluationStartDate
         *        The start of the time range that was searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationStartDate(String evaluationStartDate);

        /**
         * <p>
         * The number of groups found.
         * </p>
         * 
         * @param totalCount
         *        The number of groups found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * Statistics for individual metrics within the group.
         * </p>
         * 
         * @param itemizedMetricStatsList
         *        Statistics for individual metrics within the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemizedMetricStatsList(Collection<ItemizedMetricStats> itemizedMetricStatsList);

        /**
         * <p>
         * Statistics for individual metrics within the group.
         * </p>
         * 
         * @param itemizedMetricStatsList
         *        Statistics for individual metrics within the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemizedMetricStatsList(ItemizedMetricStats... itemizedMetricStatsList);

        /**
         * <p>
         * Statistics for individual metrics within the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStats.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStats.Builder#build()} is called
         * immediately and its result is passed to {@link #itemizedMetricStatsList(List<ItemizedMetricStats>)}.
         * 
         * @param itemizedMetricStatsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemizedMetricStatsList(java.util.Collection<ItemizedMetricStats>)
         */
        Builder itemizedMetricStatsList(Consumer<ItemizedMetricStats.Builder>... itemizedMetricStatsList);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationStartDate;

        private Integer totalCount;

        private List<ItemizedMetricStats> itemizedMetricStatsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupStatistics model) {
            evaluationStartDate(model.evaluationStartDate);
            totalCount(model.totalCount);
            itemizedMetricStatsList(model.itemizedMetricStatsList);
        }

        public final String getEvaluationStartDate() {
            return evaluationStartDate;
        }

        public final void setEvaluationStartDate(String evaluationStartDate) {
            this.evaluationStartDate = evaluationStartDate;
        }

        @Override
        public final Builder evaluationStartDate(String evaluationStartDate) {
            this.evaluationStartDate = evaluationStartDate;
            return this;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final List<ItemizedMetricStats.Builder> getItemizedMetricStatsList() {
            List<ItemizedMetricStats.Builder> result = ItemizedMetricStatsListCopier.copyToBuilder(this.itemizedMetricStatsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemizedMetricStatsList(Collection<ItemizedMetricStats.BuilderImpl> itemizedMetricStatsList) {
            this.itemizedMetricStatsList = ItemizedMetricStatsListCopier.copyFromBuilder(itemizedMetricStatsList);
        }

        @Override
        public final Builder itemizedMetricStatsList(Collection<ItemizedMetricStats> itemizedMetricStatsList) {
            this.itemizedMetricStatsList = ItemizedMetricStatsListCopier.copy(itemizedMetricStatsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemizedMetricStatsList(ItemizedMetricStats... itemizedMetricStatsList) {
            itemizedMetricStatsList(Arrays.asList(itemizedMetricStatsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemizedMetricStatsList(Consumer<ItemizedMetricStats.Builder>... itemizedMetricStatsList) {
            itemizedMetricStatsList(Stream.of(itemizedMetricStatsList)
                    .map(c -> ItemizedMetricStats.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnomalyGroupStatistics build() {
            return new AnomalyGroupStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
