/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated details about the data quality metrics collected for the <code>AnomalyDetectorArn</code> provided in the
 * <a>GetDataQualityMetrics</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyDetectorDataQualityMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyDetectorDataQualityMetric.Builder, AnomalyDetectorDataQualityMetric> {
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(AnomalyDetectorDataQualityMetric::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<List<MetricSetDataQualityMetric>> METRIC_SET_DATA_QUALITY_METRIC_LIST_FIELD = SdkField
            .<List<MetricSetDataQualityMetric>> builder(MarshallingType.LIST)
            .memberName("MetricSetDataQualityMetricList")
            .getter(getter(AnomalyDetectorDataQualityMetric::metricSetDataQualityMetricList))
            .setter(setter(Builder::metricSetDataQualityMetricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDataQualityMetricList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricSetDataQualityMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricSetDataQualityMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMESTAMP_FIELD,
            METRIC_SET_DATA_QUALITY_METRIC_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startTimestamp;

    private final List<MetricSetDataQualityMetric> metricSetDataQualityMetricList;

    private AnomalyDetectorDataQualityMetric(BuilderImpl builder) {
        this.startTimestamp = builder.startTimestamp;
        this.metricSetDataQualityMetricList = builder.metricSetDataQualityMetricList;
    }

    /**
     * <p>
     * The start time for the data quality metrics collection.
     * </p>
     * 
     * @return The start time for the data quality metrics collection.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricSetDataQualityMetricList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetricSetDataQualityMetricList() {
        return metricSetDataQualityMetricList != null && !(metricSetDataQualityMetricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information about a
     * data quality metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricSetDataQualityMetricList} method.
     * </p>
     * 
     * @return An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information
     *         about a data quality metric.
     */
    public final List<MetricSetDataQualityMetric> metricSetDataQualityMetricList() {
        return metricSetDataQualityMetricList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMetricSetDataQualityMetricList() ? metricSetDataQualityMetricList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorDataQualityMetric)) {
            return false;
        }
        AnomalyDetectorDataQualityMetric other = (AnomalyDetectorDataQualityMetric) obj;
        return Objects.equals(startTimestamp(), other.startTimestamp())
                && hasMetricSetDataQualityMetricList() == other.hasMetricSetDataQualityMetricList()
                && Objects.equals(metricSetDataQualityMetricList(), other.metricSetDataQualityMetricList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AnomalyDetectorDataQualityMetric")
                .add("StartTimestamp", startTimestamp())
                .add("MetricSetDataQualityMetricList",
                        hasMetricSetDataQualityMetricList() ? metricSetDataQualityMetricList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "MetricSetDataQualityMetricList":
            return Optional.ofNullable(clazz.cast(metricSetDataQualityMetricList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorDataQualityMetric, T> g) {
        return obj -> g.apply((AnomalyDetectorDataQualityMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyDetectorDataQualityMetric> {
        /**
         * <p>
         * The start time for the data quality metrics collection.
         * </p>
         * 
         * @param startTimestamp
         *        The start time for the data quality metrics collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information about a
         * data quality metric.
         * </p>
         * 
         * @param metricSetDataQualityMetricList
         *        An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information
         *        about a data quality metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDataQualityMetricList(Collection<MetricSetDataQualityMetric> metricSetDataQualityMetricList);

        /**
         * <p>
         * An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information about a
         * data quality metric.
         * </p>
         * 
         * @param metricSetDataQualityMetricList
         *        An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information
         *        about a data quality metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDataQualityMetricList(MetricSetDataQualityMetric... metricSetDataQualityMetricList);

        /**
         * <p>
         * An array of <code>DataQualityMetricList</code> objects. Each object in the array contains information about a
         * data quality metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetric.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #metricSetDataQualityMetricList(List<MetricSetDataQualityMetric>)}.
         * 
         * @param metricSetDataQualityMetricList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDataQualityMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSetDataQualityMetricList(java.util.Collection<MetricSetDataQualityMetric>)
         */
        Builder metricSetDataQualityMetricList(Consumer<MetricSetDataQualityMetric.Builder>... metricSetDataQualityMetricList);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTimestamp;

        private List<MetricSetDataQualityMetric> metricSetDataQualityMetricList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorDataQualityMetric model) {
            startTimestamp(model.startTimestamp);
            metricSetDataQualityMetricList(model.metricSetDataQualityMetricList);
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final List<MetricSetDataQualityMetric.Builder> getMetricSetDataQualityMetricList() {
            List<MetricSetDataQualityMetric.Builder> result = MetricSetDataQualityMetricListCopier
                    .copyToBuilder(this.metricSetDataQualityMetricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricSetDataQualityMetricList(
                Collection<MetricSetDataQualityMetric.BuilderImpl> metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList = MetricSetDataQualityMetricListCopier
                    .copyFromBuilder(metricSetDataQualityMetricList);
        }

        @Override
        public final Builder metricSetDataQualityMetricList(Collection<MetricSetDataQualityMetric> metricSetDataQualityMetricList) {
            this.metricSetDataQualityMetricList = MetricSetDataQualityMetricListCopier.copy(metricSetDataQualityMetricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetDataQualityMetricList(MetricSetDataQualityMetric... metricSetDataQualityMetricList) {
            metricSetDataQualityMetricList(Arrays.asList(metricSetDataQualityMetricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetDataQualityMetricList(
                Consumer<MetricSetDataQualityMetric.Builder>... metricSetDataQualityMetricList) {
            metricSetDataQualityMetricList(Stream.of(metricSetDataQualityMetricList)
                    .map(c -> MetricSetDataQualityMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnomalyDetectorDataQualityMetric build() {
            return new AnomalyDetectorDataQualityMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
