/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lookoutmetrics.internal.LookoutMetricsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lookoutmetrics.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ConflictException;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.InternalServerException;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsException;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutmetrics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TooManyRequestsException;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ValidationException;
import software.amazon.awssdk.services.lookoutmetrics.transform.ActivateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.BackTestAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateMetricSetRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeactivateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeleteAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeleteAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAnomalyDetectionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeMetricSetRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DetectMetricSetConfigRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetAnomalyGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetDataQualityMetricsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetFeedbackRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetSampleDataRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAlertsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupRelatedMetricsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupSummariesRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListMetricSetsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateMetricSetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link LookoutMetricsClient}.
 *
 * @see LookoutMetricsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLookoutMetricsClient implements LookoutMetricsClient {
    private static final Logger log = Logger.loggerFor(DefaultLookoutMetricsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final LookoutMetricsServiceClientConfiguration serviceClientConfiguration;

    protected DefaultLookoutMetricsClient(LookoutMetricsServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Activates an anomaly detector.
     * </p>
     *
     * @param activateAnomalyDetectorRequest
     * @return Result of the ActivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ActivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ActivateAnomalyDetectorResponse activateAnomalyDetector(ActivateAnomalyDetectorRequest activateAnomalyDetectorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ActivateAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ActivateAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<ActivateAnomalyDetectorRequest, ActivateAnomalyDetectorResponse>()
                            .withOperationName("ActivateAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(activateAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ActivateAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs a backtest for anomaly detection for the specified resource.
     * </p>
     *
     * @param backTestAnomalyDetectorRequest
     * @return Result of the BackTestAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.BackTestAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BackTestAnomalyDetectorResponse backTestAnomalyDetector(BackTestAnomalyDetectorRequest backTestAnomalyDetectorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BackTestAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BackTestAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(backTestAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, backTestAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BackTestAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<BackTestAnomalyDetectorRequest, BackTestAnomalyDetectorResponse>()
                            .withOperationName("BackTestAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(backTestAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BackTestAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an alert for an anomaly detector.
     * </p>
     *
     * @param createAlertRequest
     * @return Result of the CreateAlert operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAlertResponse createAlert(CreateAlertRequest createAlertRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAlertResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAlertResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAlertRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAlertRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlert");

            return clientHandler.execute(new ClientExecutionParams<CreateAlertRequest, CreateAlertResponse>()
                    .withOperationName("CreateAlert").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createAlertRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAlertRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an anomaly detector.
     * </p>
     *
     * @param createAnomalyDetectorRequest
     * @return Result of the CreateAnomalyDetector operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAnomalyDetectorResponse createAnomalyDetector(CreateAnomalyDetectorRequest createAnomalyDetectorRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnomalyDetector");

            return clientHandler.execute(new ClientExecutionParams<CreateAnomalyDetectorRequest, CreateAnomalyDetectorResponse>()
                    .withOperationName("CreateAnomalyDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAnomalyDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     *
     * @param createMetricSetRequest
     * @return Result of the CreateMetricSet operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMetricSetResponse createMetricSet(CreateMetricSetRequest createMetricSetRequest) throws ConflictException,
            ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMetricSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMetricSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMetricSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMetricSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMetricSet");

            return clientHandler.execute(new ClientExecutionParams<CreateMetricSetRequest, CreateMetricSetResponse>()
                    .withOperationName("CreateMetricSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMetricSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMetricSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates an anomaly detector.
     * </p>
     *
     * @param deactivateAnomalyDetectorRequest
     * @return Result of the DeactivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeactivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeactivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeactivateAnomalyDetectorResponse deactivateAnomalyDetector(
            DeactivateAnomalyDetectorRequest deactivateAnomalyDetectorRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeactivateAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeactivateAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<DeactivateAnomalyDetectorRequest, DeactivateAnomalyDetectorResponse>()
                            .withOperationName("DeactivateAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deactivateAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeactivateAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an alert.
     * </p>
     *
     * @param deleteAlertRequest
     * @return Result of the DeleteAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAlertResponse deleteAlert(DeleteAlertRequest deleteAlertRequest) throws ResourceNotFoundException,
            ValidationException, TooManyRequestsException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAlertResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAlertResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAlertRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAlertRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlert");

            return clientHandler.execute(new ClientExecutionParams<DeleteAlertRequest, DeleteAlertResponse>()
                    .withOperationName("DeleteAlert").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAlertRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAlertRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
     * configured datasets and alerts.
     * </p>
     *
     * @param deleteAnomalyDetectorRequest
     * @return Result of the DeleteAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAnomalyDetectorResponse deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, TooManyRequestsException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnomalyDetector");

            return clientHandler.execute(new ClientExecutionParams<DeleteAnomalyDetectorRequest, DeleteAnomalyDetectorResponse>()
                    .withOperationName("DeleteAnomalyDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAnomalyDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an alert.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAlertRequest
     * @return Result of the DescribeAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAlertResponse describeAlert(DescribeAlertRequest describeAlertRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAlertResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAlertResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAlertRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAlertRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlert");

            return clientHandler.execute(new ClientExecutionParams<DescribeAlertRequest, DescribeAlertResponse>()
                    .withOperationName("DescribeAlert").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAlertRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAlertRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     * @return Result of the DescribeAnomalyDetectionExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnomalyDetectionExecutionsResponse describeAnomalyDetectionExecutions(
            DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnomalyDetectionExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnomalyDetectionExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnomalyDetectionExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAnomalyDetectionExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnomalyDetectionExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnomalyDetectionExecutionsRequest, DescribeAnomalyDetectionExecutionsResponse>()
                            .withOperationName("DescribeAnomalyDetectionExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAnomalyDetectionExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnomalyDetectionExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAnomalyDetectorRequest
     * @return Result of the DescribeAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnomalyDetectorResponse describeAnomalyDetector(DescribeAnomalyDetectorRequest describeAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnomalyDetectorRequest, DescribeAnomalyDetectorResponse>()
                            .withOperationName("DescribeAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeMetricSetRequest
     * @return Result of the DescribeMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMetricSetResponse describeMetricSet(DescribeMetricSetRequest describeMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMetricSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeMetricSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetricSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMetricSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetricSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeMetricSetRequest, DescribeMetricSetResponse>()
                    .withOperationName("DescribeMetricSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeMetricSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeMetricSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     * </p>
     *
     * @param detectMetricSetConfigRequest
     * @return Result of the DetectMetricSetConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DetectMetricSetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DetectMetricSetConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectMetricSetConfigResponse detectMetricSetConfig(DetectMetricSetConfigRequest detectMetricSetConfigRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetectMetricSetConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DetectMetricSetConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectMetricSetConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectMetricSetConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectMetricSetConfig");

            return clientHandler.execute(new ClientExecutionParams<DetectMetricSetConfigRequest, DetectMetricSetConfigResponse>()
                    .withOperationName("DetectMetricSetConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detectMetricSetConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectMetricSetConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about a group of anomalous metrics.
     * </p>
     *
     * @param getAnomalyGroupRequest
     * @return Result of the GetAnomalyGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetAnomalyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAnomalyGroupResponse getAnomalyGroup(GetAnomalyGroupRequest getAnomalyGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnomalyGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAnomalyGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnomalyGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnomalyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnomalyGroup");

            return clientHandler.execute(new ClientExecutionParams<GetAnomalyGroupRequest, GetAnomalyGroupResponse>()
                    .withOperationName("GetAnomalyGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAnomalyGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAnomalyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about the requested data quality metrics.
     * </p>
     *
     * @param getDataQualityMetricsRequest
     * @return Result of the GetDataQualityMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetDataQualityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetDataQualityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDataQualityMetricsResponse getDataQualityMetrics(GetDataQualityMetricsRequest getDataQualityMetricsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataQualityMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDataQualityMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataQualityMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataQualityMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataQualityMetrics");

            return clientHandler.execute(new ClientExecutionParams<GetDataQualityMetricsRequest, GetDataQualityMetricsResponse>()
                    .withOperationName("GetDataQualityMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDataQualityMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataQualityMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     *
     * @param getFeedbackRequest
     * @return Result of the GetFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetFeedbackResponse getFeedback(GetFeedbackRequest getFeedbackRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFeedbackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFeedback");

            return clientHandler.execute(new ClientExecutionParams<GetFeedbackRequest, GetFeedbackResponse>()
                    .withOperationName("GetFeedback").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getFeedbackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFeedbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a selection of sample records from an Amazon S3 datasource.
     * </p>
     *
     * @param getSampleDataRequest
     * @return Result of the GetSampleData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetSampleData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSampleDataResponse getSampleData(GetSampleDataRequest getSampleDataRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSampleDataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSampleDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSampleDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSampleDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSampleData");

            return clientHandler.execute(new ClientExecutionParams<GetSampleDataRequest, GetSampleDataResponse>()
                    .withOperationName("GetSampleData").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSampleDataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSampleDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAlertsRequest
     * @return Result of the ListAlerts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, ValidationException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAlertsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAlertsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAlertsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlertsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlerts");

            return clientHandler.execute(new ClientExecutionParams<ListAlertsRequest, ListAlertsResponse>()
                    .withOperationName("ListAlerts").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listAlertsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAlertsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     * @return Result of the ListAnomalyDetectors operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnomalyDetectorsResponse listAnomalyDetectors(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnomalyDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnomalyDetectorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnomalyDetectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnomalyDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnomalyDetectors");

            return clientHandler.execute(new ClientExecutionParams<ListAnomalyDetectorsRequest, ListAnomalyDetectorsResponse>()
                    .withOperationName("ListAnomalyDetectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAnomalyDetectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnomalyDetectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     * @return Result of the ListAnomalyGroupRelatedMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnomalyGroupRelatedMetricsResponse listAnomalyGroupRelatedMetrics(
            ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnomalyGroupRelatedMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnomalyGroupRelatedMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnomalyGroupRelatedMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAnomalyGroupRelatedMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnomalyGroupRelatedMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnomalyGroupRelatedMetricsRequest, ListAnomalyGroupRelatedMetricsResponse>()
                            .withOperationName("ListAnomalyGroupRelatedMetrics").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAnomalyGroupRelatedMetricsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnomalyGroupRelatedMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     * @return Result of the ListAnomalyGroupSummaries operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnomalyGroupSummariesResponse listAnomalyGroupSummaries(
            ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnomalyGroupSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnomalyGroupSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnomalyGroupSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnomalyGroupSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnomalyGroupSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnomalyGroupSummariesRequest, ListAnomalyGroupSummariesResponse>()
                            .withOperationName("ListAnomalyGroupSummaries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAnomalyGroupSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnomalyGroupSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     * @return Result of the ListAnomalyGroupTimeSeries operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnomalyGroupTimeSeriesResponse listAnomalyGroupTimeSeries(
            ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnomalyGroupTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnomalyGroupTimeSeriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnomalyGroupTimeSeriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnomalyGroupTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnomalyGroupTimeSeries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnomalyGroupTimeSeriesRequest, ListAnomalyGroupTimeSeriesResponse>()
                            .withOperationName("ListAnomalyGroupTimeSeries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAnomalyGroupTimeSeriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnomalyGroupTimeSeriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listMetricSetsRequest
     * @return Result of the ListMetricSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMetricSetsResponse listMetricSets(ListMetricSetsRequest listMetricSetsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMetricSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMetricSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMetricSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMetricSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMetricSets");

            return clientHandler.execute(new ClientExecutionParams<ListMetricSetsRequest, ListMetricSetsResponse>()
                    .withOperationName("ListMetricSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMetricSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMetricSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a
     * detector, dataset, or alert.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add feedback for an anomalous metric.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutFeedbackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFeedback");

            return clientHandler.execute(new ClientExecutionParams<PutFeedbackRequest, PutFeedbackResponse>()
                    .withOperationName("PutFeedback").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putFeedbackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutFeedbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector,
     * dataset, or alert.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a
     * detector, dataset, or alert.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Make changes to an existing alert.
     * </p>
     *
     * @param updateAlertRequest
     * @return Result of the UpdateAlert operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAlertResponse updateAlert(UpdateAlertRequest updateAlertRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAlertResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAlertResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAlertRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAlertRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAlert");

            return clientHandler.execute(new ClientExecutionParams<UpdateAlertRequest, UpdateAlertResponse>()
                    .withOperationName("UpdateAlert").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAlertRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAlertRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     * </p>
     *
     * @param updateAnomalyDetectorRequest
     * @return Result of the UpdateAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAnomalyDetectorResponse updateAnomalyDetector(UpdateAnomalyDetectorRequest updateAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnomalyDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnomalyDetector");

            return clientHandler.execute(new ClientExecutionParams<UpdateAnomalyDetectorRequest, UpdateAnomalyDetectorResponse>()
                    .withOperationName("UpdateAnomalyDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAnomalyDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     *
     * @param updateMetricSetRequest
     * @return Result of the UpdateMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMetricSetResponse updateMetricSet(UpdateMetricSetRequest updateMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMetricSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMetricSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMetricSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMetricSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMetricSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateMetricSetRequest, UpdateMetricSetResponse>()
                    .withOperationName("UpdateMetricSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateMetricSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMetricSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        LookoutMetricsServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = LookoutMetricsServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LookoutMetricsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build());
    }

    @Override
    public final LookoutMetricsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
