/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An inferred data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedMetricSource implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedMetricSource.Builder, DetectedMetricSource> {
    private static final SdkField<DetectedS3SourceConfig> S3_SOURCE_CONFIG_FIELD = SdkField
            .<DetectedS3SourceConfig> builder(MarshallingType.SDK_POJO).memberName("S3SourceConfig")
            .getter(getter(DetectedMetricSource::s3SourceConfig)).setter(setter(Builder::s3SourceConfig))
            .constructor(DetectedS3SourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SourceConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SOURCE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectedS3SourceConfig s3SourceConfig;

    private DetectedMetricSource(BuilderImpl builder) {
        this.s3SourceConfig = builder.s3SourceConfig;
    }

    /**
     * <p>
     * The data source's source configuration.
     * </p>
     * 
     * @return The data source's source configuration.
     */
    public final DetectedS3SourceConfig s3SourceConfig() {
        return s3SourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3SourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedMetricSource)) {
            return false;
        }
        DetectedMetricSource other = (DetectedMetricSource) obj;
        return Objects.equals(s3SourceConfig(), other.s3SourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedMetricSource").add("S3SourceConfig", s3SourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3SourceConfig":
            return Optional.ofNullable(clazz.cast(s3SourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedMetricSource, T> g) {
        return obj -> g.apply((DetectedMetricSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedMetricSource> {
        /**
         * <p>
         * The data source's source configuration.
         * </p>
         * 
         * @param s3SourceConfig
         *        The data source's source configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SourceConfig(DetectedS3SourceConfig s3SourceConfig);

        /**
         * <p>
         * The data source's source configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedS3SourceConfig.Builder} avoiding
         * the need to create one manually via {@link DetectedS3SourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedS3SourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3SourceConfig(DetectedS3SourceConfig)}.
         * 
         * @param s3SourceConfig
         *        a consumer that will call methods on {@link DetectedS3SourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3SourceConfig(DetectedS3SourceConfig)
         */
        default Builder s3SourceConfig(Consumer<DetectedS3SourceConfig.Builder> s3SourceConfig) {
            return s3SourceConfig(DetectedS3SourceConfig.builder().applyMutation(s3SourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedS3SourceConfig s3SourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedMetricSource model) {
            s3SourceConfig(model.s3SourceConfig);
        }

        public final DetectedS3SourceConfig.Builder getS3SourceConfig() {
            return s3SourceConfig != null ? s3SourceConfig.toBuilder() : null;
        }

        public final void setS3SourceConfig(DetectedS3SourceConfig.BuilderImpl s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig != null ? s3SourceConfig.build() : null;
        }

        @Override
        public final Builder s3SourceConfig(DetectedS3SourceConfig s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig;
            return this;
        }

        @Override
        public DetectedMetricSource build() {
            return new DetectedMetricSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
