/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of an inferred data format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedFileFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedFileFormatDescriptor.Builder, DetectedFileFormatDescriptor> {
    private static final SdkField<DetectedCsvFormatDescriptor> CSV_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<DetectedCsvFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("CsvFormatDescriptor")
            .getter(getter(DetectedFileFormatDescriptor::csvFormatDescriptor)).setter(setter(Builder::csvFormatDescriptor))
            .constructor(DetectedCsvFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvFormatDescriptor").build())
            .build();

    private static final SdkField<DetectedJsonFormatDescriptor> JSON_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<DetectedJsonFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("JsonFormatDescriptor")
            .getter(getter(DetectedFileFormatDescriptor::jsonFormatDescriptor)).setter(setter(Builder::jsonFormatDescriptor))
            .constructor(DetectedJsonFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonFormatDescriptor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FORMAT_DESCRIPTOR_FIELD,
            JSON_FORMAT_DESCRIPTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectedCsvFormatDescriptor csvFormatDescriptor;

    private final DetectedJsonFormatDescriptor jsonFormatDescriptor;

    private DetectedFileFormatDescriptor(BuilderImpl builder) {
        this.csvFormatDescriptor = builder.csvFormatDescriptor;
        this.jsonFormatDescriptor = builder.jsonFormatDescriptor;
    }

    /**
     * <p>
     * Details about a CSV format.
     * </p>
     * 
     * @return Details about a CSV format.
     */
    public final DetectedCsvFormatDescriptor csvFormatDescriptor() {
        return csvFormatDescriptor;
    }

    /**
     * <p>
     * Details about a JSON format.
     * </p>
     * 
     * @return Details about a JSON format.
     */
    public final DetectedJsonFormatDescriptor jsonFormatDescriptor() {
        return jsonFormatDescriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csvFormatDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(jsonFormatDescriptor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedFileFormatDescriptor)) {
            return false;
        }
        DetectedFileFormatDescriptor other = (DetectedFileFormatDescriptor) obj;
        return Objects.equals(csvFormatDescriptor(), other.csvFormatDescriptor())
                && Objects.equals(jsonFormatDescriptor(), other.jsonFormatDescriptor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedFileFormatDescriptor").add("CsvFormatDescriptor", csvFormatDescriptor())
                .add("JsonFormatDescriptor", jsonFormatDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CsvFormatDescriptor":
            return Optional.ofNullable(clazz.cast(csvFormatDescriptor()));
        case "JsonFormatDescriptor":
            return Optional.ofNullable(clazz.cast(jsonFormatDescriptor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedFileFormatDescriptor, T> g) {
        return obj -> g.apply((DetectedFileFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedFileFormatDescriptor> {
        /**
         * <p>
         * Details about a CSV format.
         * </p>
         * 
         * @param csvFormatDescriptor
         *        Details about a CSV format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvFormatDescriptor(DetectedCsvFormatDescriptor csvFormatDescriptor);

        /**
         * <p>
         * Details about a CSV format.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedCsvFormatDescriptor.Builder}
         * avoiding the need to create one manually via {@link DetectedCsvFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedCsvFormatDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #csvFormatDescriptor(DetectedCsvFormatDescriptor)}.
         * 
         * @param csvFormatDescriptor
         *        a consumer that will call methods on {@link DetectedCsvFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvFormatDescriptor(DetectedCsvFormatDescriptor)
         */
        default Builder csvFormatDescriptor(Consumer<DetectedCsvFormatDescriptor.Builder> csvFormatDescriptor) {
            return csvFormatDescriptor(DetectedCsvFormatDescriptor.builder().applyMutation(csvFormatDescriptor).build());
        }

        /**
         * <p>
         * Details about a JSON format.
         * </p>
         * 
         * @param jsonFormatDescriptor
         *        Details about a JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonFormatDescriptor(DetectedJsonFormatDescriptor jsonFormatDescriptor);

        /**
         * <p>
         * Details about a JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedJsonFormatDescriptor.Builder}
         * avoiding the need to create one manually via {@link DetectedJsonFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedJsonFormatDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #jsonFormatDescriptor(DetectedJsonFormatDescriptor)}.
         * 
         * @param jsonFormatDescriptor
         *        a consumer that will call methods on {@link DetectedJsonFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonFormatDescriptor(DetectedJsonFormatDescriptor)
         */
        default Builder jsonFormatDescriptor(Consumer<DetectedJsonFormatDescriptor.Builder> jsonFormatDescriptor) {
            return jsonFormatDescriptor(DetectedJsonFormatDescriptor.builder().applyMutation(jsonFormatDescriptor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedCsvFormatDescriptor csvFormatDescriptor;

        private DetectedJsonFormatDescriptor jsonFormatDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedFileFormatDescriptor model) {
            csvFormatDescriptor(model.csvFormatDescriptor);
            jsonFormatDescriptor(model.jsonFormatDescriptor);
        }

        public final DetectedCsvFormatDescriptor.Builder getCsvFormatDescriptor() {
            return csvFormatDescriptor != null ? csvFormatDescriptor.toBuilder() : null;
        }

        public final void setCsvFormatDescriptor(DetectedCsvFormatDescriptor.BuilderImpl csvFormatDescriptor) {
            this.csvFormatDescriptor = csvFormatDescriptor != null ? csvFormatDescriptor.build() : null;
        }

        @Override
        public final Builder csvFormatDescriptor(DetectedCsvFormatDescriptor csvFormatDescriptor) {
            this.csvFormatDescriptor = csvFormatDescriptor;
            return this;
        }

        public final DetectedJsonFormatDescriptor.Builder getJsonFormatDescriptor() {
            return jsonFormatDescriptor != null ? jsonFormatDescriptor.toBuilder() : null;
        }

        public final void setJsonFormatDescriptor(DetectedJsonFormatDescriptor.BuilderImpl jsonFormatDescriptor) {
            this.jsonFormatDescriptor = jsonFormatDescriptor != null ? jsonFormatDescriptor.build() : null;
        }

        @Override
        public final Builder jsonFormatDescriptor(DetectedJsonFormatDescriptor jsonFormatDescriptor) {
            this.jsonFormatDescriptor = jsonFormatDescriptor;
            return this;
        }

        @Override
        public DetectedFileFormatDescriptor build() {
            return new DetectedFileFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
