/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyGroupStatistics;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyGroupSummary;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyGroupSummaryListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomalyGroupSummariesResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, ListAnomalyGroupSummariesResponse> {
    private static final SdkField<List<AnomalyGroupSummary>> ANOMALY_GROUP_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyGroupSummaryList").getter(ListAnomalyGroupSummariesResponse.getter(ListAnomalyGroupSummariesResponse::anomalyGroupSummaryList)).setter(ListAnomalyGroupSummariesResponse.setter(Builder::anomalyGroupSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnomalyGroupStatistics> ANOMALY_GROUP_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyGroupStatistics").getter(ListAnomalyGroupSummariesResponse.getter(ListAnomalyGroupSummariesResponse::anomalyGroupStatistics)).setter(ListAnomalyGroupSummariesResponse.setter(Builder::anomalyGroupStatistics)).constructor(AnomalyGroupStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupStatistics").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomalyGroupSummariesResponse.getter(ListAnomalyGroupSummariesResponse::nextToken)).setter(ListAnomalyGroupSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_SUMMARY_LIST_FIELD, ANOMALY_GROUP_STATISTICS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnomalyGroupSummary> anomalyGroupSummaryList;
    private final AnomalyGroupStatistics anomalyGroupStatistics;
    private final String nextToken;

    private ListAnomalyGroupSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupSummaryList = builder.anomalyGroupSummaryList;
        this.anomalyGroupStatistics = builder.anomalyGroupStatistics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnomalyGroupSummaryList() {
        return this.anomalyGroupSummaryList != null && !(this.anomalyGroupSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AnomalyGroupSummary> anomalyGroupSummaryList() {
        return this.anomalyGroupSummaryList;
    }

    public final AnomalyGroupStatistics anomalyGroupStatistics() {
        return this.anomalyGroupStatistics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyGroupSummaryList() ? this.anomalyGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupSummariesResponse)) {
            return false;
        }
        ListAnomalyGroupSummariesResponse other = (ListAnomalyGroupSummariesResponse)((Object)obj);
        return this.hasAnomalyGroupSummaryList() == other.hasAnomalyGroupSummaryList() && Objects.equals(this.anomalyGroupSummaryList(), other.anomalyGroupSummaryList()) && Objects.equals(this.anomalyGroupStatistics(), other.anomalyGroupStatistics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomalyGroupSummariesResponse").add("AnomalyGroupSummaryList", this.hasAnomalyGroupSummaryList() ? this.anomalyGroupSummaryList() : null).add("AnomalyGroupStatistics", (Object)this.anomalyGroupStatistics()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyGroupSummaryList": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupSummaryList()));
            }
            case "AnomalyGroupStatistics": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupStatistics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupSummariesResponse, T> g) {
        return obj -> g.apply((ListAnomalyGroupSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<AnomalyGroupSummary> anomalyGroupSummaryList = DefaultSdkAutoConstructList.getInstance();
        private AnomalyGroupStatistics anomalyGroupStatistics;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupSummariesResponse model) {
            super(model);
            this.anomalyGroupSummaryList(model.anomalyGroupSummaryList);
            this.anomalyGroupStatistics(model.anomalyGroupStatistics);
            this.nextToken(model.nextToken);
        }

        public final List<AnomalyGroupSummary.Builder> getAnomalyGroupSummaryList() {
            List<AnomalyGroupSummary.Builder> result = AnomalyGroupSummaryListCopier.copyToBuilder(this.anomalyGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyGroupSummaryList(Collection<AnomalyGroupSummary.BuilderImpl> anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList = AnomalyGroupSummaryListCopier.copyFromBuilder(anomalyGroupSummaryList);
        }

        @Override
        public final Builder anomalyGroupSummaryList(Collection<AnomalyGroupSummary> anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList = AnomalyGroupSummaryListCopier.copy(anomalyGroupSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupSummaryList(AnomalyGroupSummary ... anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList(Arrays.asList(anomalyGroupSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupSummaryList(Consumer<AnomalyGroupSummary.Builder> ... anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList(Stream.of(anomalyGroupSummaryList).map(c -> (AnomalyGroupSummary)((AnomalyGroupSummary.Builder)AnomalyGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnomalyGroupStatistics.Builder getAnomalyGroupStatistics() {
            return this.anomalyGroupStatistics != null ? this.anomalyGroupStatistics.toBuilder() : null;
        }

        public final void setAnomalyGroupStatistics(AnomalyGroupStatistics.BuilderImpl anomalyGroupStatistics) {
            this.anomalyGroupStatistics = anomalyGroupStatistics != null ? anomalyGroupStatistics.build() : null;
        }

        @Override
        public final Builder anomalyGroupStatistics(AnomalyGroupStatistics anomalyGroupStatistics) {
            this.anomalyGroupStatistics = anomalyGroupStatistics;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalyGroupSummariesResponse build() {
            return new ListAnomalyGroupSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomalyGroupSummariesResponse> {
        public Builder anomalyGroupSummaryList(Collection<AnomalyGroupSummary> var1);

        public Builder anomalyGroupSummaryList(AnomalyGroupSummary ... var1);

        public Builder anomalyGroupSummaryList(Consumer<AnomalyGroupSummary.Builder> ... var1);

        public Builder anomalyGroupStatistics(AnomalyGroupStatistics var1);

        default public Builder anomalyGroupStatistics(Consumer<AnomalyGroupStatistics.Builder> anomalyGroupStatistics) {
            return this.anomalyGroupStatistics((AnomalyGroupStatistics)((AnomalyGroupStatistics.Builder)AnomalyGroupStatistics.builder().applyMutation(anomalyGroupStatistics)).build());
        }

        public Builder nextToken(String var1);
    }
}

