/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionValueContribution;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionValueContributionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionContribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionContribution> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionName").getter(DimensionContribution.getter(DimensionContribution::dimensionName)).setter(DimensionContribution.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()}).build();
    private static final SdkField<List<DimensionValueContribution>> DIMENSION_VALUE_CONTRIBUTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionValueContributionList").getter(DimensionContribution.getter(DimensionContribution::dimensionValueContributionList)).setter(DimensionContribution.setter(Builder::dimensionValueContributionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueContributionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionValueContribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD, DIMENSION_VALUE_CONTRIBUTION_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dimensionName;
    private final List<DimensionValueContribution> dimensionValueContributionList;

    private DimensionContribution(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueContributionList = builder.dimensionValueContributionList;
    }

    public final String dimensionName() {
        return this.dimensionName;
    }

    public final boolean hasDimensionValueContributionList() {
        return this.dimensionValueContributionList != null && !(this.dimensionValueContributionList instanceof SdkAutoConstructList);
    }

    public final List<DimensionValueContribution> dimensionValueContributionList() {
        return this.dimensionValueContributionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionValueContributionList() ? this.dimensionValueContributionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionContribution)) {
            return false;
        }
        DimensionContribution other = (DimensionContribution)obj;
        return Objects.equals(this.dimensionName(), other.dimensionName()) && this.hasDimensionValueContributionList() == other.hasDimensionValueContributionList() && Objects.equals(this.dimensionValueContributionList(), other.dimensionValueContributionList());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionContribution").add("DimensionName", (Object)this.dimensionName()).add("DimensionValueContributionList", this.hasDimensionValueContributionList() ? this.dimensionValueContributionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
            case "DimensionValueContributionList": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueContributionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionContribution, T> g) {
        return obj -> g.apply((DimensionContribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private List<DimensionValueContribution> dimensionValueContributionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionContribution model) {
            this.dimensionName(model.dimensionName);
            this.dimensionValueContributionList(model.dimensionValueContributionList);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final List<DimensionValueContribution.Builder> getDimensionValueContributionList() {
            List<DimensionValueContribution.Builder> result = DimensionValueContributionListCopier.copyToBuilder(this.dimensionValueContributionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionValueContributionList(Collection<DimensionValueContribution.BuilderImpl> dimensionValueContributionList) {
            this.dimensionValueContributionList = DimensionValueContributionListCopier.copyFromBuilder(dimensionValueContributionList);
        }

        @Override
        public final Builder dimensionValueContributionList(Collection<DimensionValueContribution> dimensionValueContributionList) {
            this.dimensionValueContributionList = DimensionValueContributionListCopier.copy(dimensionValueContributionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueContributionList(DimensionValueContribution ... dimensionValueContributionList) {
            this.dimensionValueContributionList(Arrays.asList(dimensionValueContributionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueContributionList(Consumer<DimensionValueContribution.Builder> ... dimensionValueContributionList) {
            this.dimensionValueContributionList(Stream.of(dimensionValueContributionList).map(c -> (DimensionValueContribution)((DimensionValueContribution.Builder)DimensionValueContribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DimensionContribution build() {
            return new DimensionContribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionContribution> {
        public Builder dimensionName(String var1);

        public Builder dimensionValueContributionList(Collection<DimensionValueContribution> var1);

        public Builder dimensionValueContributionList(DimensionValueContribution ... var1);

        public Builder dimensionValueContributionList(Consumer<DimensionValueContribution.Builder> ... var1);
    }
}

