/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataQualityMetricType {
    COLUMN_COMPLETENESS("COLUMN_COMPLETENESS"),
    DIMENSION_UNIQUENESS("DIMENSION_UNIQUENESS"),
    TIME_SERIES_COUNT("TIME_SERIES_COUNT"),
    ROWS_PROCESSED("ROWS_PROCESSED"),
    ROWS_PARTIAL_COMPLIANCE("ROWS_PARTIAL_COMPLIANCE"),
    INVALID_ROWS_COMPLIANCE("INVALID_ROWS_COMPLIANCE"),
    BACKTEST_TRAINING_DATA_START_TIME_STAMP("BACKTEST_TRAINING_DATA_START_TIME_STAMP"),
    BACKTEST_TRAINING_DATA_END_TIME_STAMP("BACKTEST_TRAINING_DATA_END_TIME_STAMP"),
    BACKTEST_INFERENCE_DATA_START_TIME_STAMP("BACKTEST_INFERENCE_DATA_START_TIME_STAMP"),
    BACKTEST_INFERENCE_DATA_END_TIME_STAMP("BACKTEST_INFERENCE_DATA_END_TIME_STAMP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataQualityMetricType> VALUE_MAP;
    private final String value;

    private DataQualityMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataQualityMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataQualityMetricType> knownValues() {
        EnumSet<DataQualityMetricType> knownValues = EnumSet.allOf(DataQualityMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataQualityMetricType.class, DataQualityMetricType::toString);
    }
}

