/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRetrainingSchedulerRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<UpdateRetrainingSchedulerRequest.Builder, UpdateRetrainingSchedulerRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(UpdateRetrainingSchedulerRequest::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetrainingStartDate").getter(getter(UpdateRetrainingSchedulerRequest::retrainingStartDate))
            .setter(setter(Builder::retrainingStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build())
            .build();

    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrainingFrequency").getter(getter(UpdateRetrainingSchedulerRequest::retrainingFrequency))
            .setter(setter(Builder::retrainingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build())
            .build();

    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackWindow").getter(getter(UpdateRetrainingSchedulerRequest::lookbackWindow))
            .setter(setter(Builder::lookbackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()).build();

    private static final SdkField<String> PROMOTE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromoteMode").getter(getter(UpdateRetrainingSchedulerRequest::promoteModeAsString))
            .setter(setter(Builder::promoteMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromoteMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD, PROMOTE_MODE_FIELD));

    private final String modelName;

    private final Instant retrainingStartDate;

    private final String retrainingFrequency;

    private final String lookbackWindow;

    private final String promoteMode;

    private UpdateRetrainingSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
        this.promoteMode = builder.promoteMode;
    }

    /**
     * <p>
     * The name of the model whose retraining scheduler you want to update.
     * </p>
     * 
     * @return The name of the model whose retraining scheduler you want to update.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest
     * UTC day.
     * </p>
     * 
     * @return The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
     *         nearest UTC day.
     */
    public final Instant retrainingStartDate() {
        return retrainingStartDate;
    }

    /**
     * <p>
     * This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> standard to set
     * the frequency at which you want retraining to occur in terms of Years, Months, and/or Days (note: other
     * parameters like Time are not currently supported). The minimum value is 30 days (P30D) and the maximum value is 1
     * year (P1Y). For example, the following values are valid:
     * </p>
     * <ul>
     * <li>
     * <p>
     * P3M15D – Every 3 months and 15 days
     * </p>
     * </li>
     * <li>
     * <p>
     * P2M – Every 2 months
     * </p>
     * </li>
     * <li>
     * <p>
     * P150D – Every 150 days
     * </p>
     * </li>
     * </ul>
     * 
     * @return This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> standard
     *         to set the frequency at which you want retraining to occur in terms of Years, Months, and/or Days (note:
     *         other parameters like Time are not currently supported). The minimum value is 30 days (P30D) and the
     *         maximum value is 1 year (P1Y). For example, the following values are valid:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         P3M15D – Every 3 months and 15 days
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         P2M – Every 2 months
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         P150D – Every 150 days
     *         </p>
     *         </li>
     */
    public final String retrainingFrequency() {
        return retrainingFrequency;
    }

    /**
     * <p>
     * The number of past days of data that will be used for retraining.
     * </p>
     * 
     * @return The number of past days of data that will be used for retraining.
     */
    public final String lookbackWindow() {
        return lookbackWindow;
    }

    /**
     * <p>
     * Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be
     * used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
     * models will not be used <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation">until
     * they are manually activated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promoteMode} will
     * return {@link ModelPromoteMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promoteModeAsString}.
     * </p>
     * 
     * @return Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will
     *         automatically be used for inference if they have better performance than the current model. In
     *         <code>MANUAL</code> mode, the new models will not be used <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     *         >until they are manually activated</a>.
     * @see ModelPromoteMode
     */
    public final ModelPromoteMode promoteMode() {
        return ModelPromoteMode.fromValue(promoteMode);
    }

    /**
     * <p>
     * Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be
     * used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
     * models will not be used <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation">until
     * they are manually activated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promoteMode} will
     * return {@link ModelPromoteMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promoteModeAsString}.
     * </p>
     * 
     * @return Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will
     *         automatically be used for inference if they have better performance than the current model. In
     *         <code>MANUAL</code> mode, the new models will not be used <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     *         >until they are manually activated</a>.
     * @see ModelPromoteMode
     */
    public final String promoteModeAsString() {
        return promoteMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(promoteModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRetrainingSchedulerRequest)) {
            return false;
        }
        UpdateRetrainingSchedulerRequest other = (UpdateRetrainingSchedulerRequest) obj;
        return Objects.equals(modelName(), other.modelName())
                && Objects.equals(retrainingStartDate(), other.retrainingStartDate())
                && Objects.equals(retrainingFrequency(), other.retrainingFrequency())
                && Objects.equals(lookbackWindow(), other.lookbackWindow())
                && Objects.equals(promoteModeAsString(), other.promoteModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRetrainingSchedulerRequest").add("ModelName", modelName())
                .add("RetrainingStartDate", retrainingStartDate()).add("RetrainingFrequency", retrainingFrequency())
                .add("LookbackWindow", lookbackWindow()).add("PromoteMode", promoteModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "RetrainingStartDate":
            return Optional.ofNullable(clazz.cast(retrainingStartDate()));
        case "RetrainingFrequency":
            return Optional.ofNullable(clazz.cast(retrainingFrequency()));
        case "LookbackWindow":
            return Optional.ofNullable(clazz.cast(lookbackWindow()));
        case "PromoteMode":
            return Optional.ofNullable(clazz.cast(promoteModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRetrainingSchedulerRequest, T> g) {
        return obj -> g.apply((UpdateRetrainingSchedulerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRetrainingSchedulerRequest> {
        /**
         * <p>
         * The name of the model whose retraining scheduler you want to update.
         * </p>
         * 
         * @param modelName
         *        The name of the model whose retraining scheduler you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
         * nearest UTC day.
         * </p>
         * 
         * @param retrainingStartDate
         *        The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to
         *        the nearest UTC day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingStartDate(Instant retrainingStartDate);

        /**
         * <p>
         * This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> standard to
         * set the frequency at which you want retraining to occur in terms of Years, Months, and/or Days (note: other
         * parameters like Time are not currently supported). The minimum value is 30 days (P30D) and the maximum value
         * is 1 year (P1Y). For example, the following values are valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * P3M15D – Every 3 months and 15 days
         * </p>
         * </li>
         * <li>
         * <p>
         * P2M – Every 2 months
         * </p>
         * </li>
         * <li>
         * <p>
         * P150D – Every 150 days
         * </p>
         * </li>
         * </ul>
         * 
         * @param retrainingFrequency
         *        This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a>
         *        standard to set the frequency at which you want retraining to occur in terms of Years, Months, and/or
         *        Days (note: other parameters like Time are not currently supported). The minimum value is 30 days
         *        (P30D) and the maximum value is 1 year (P1Y). For example, the following values are valid:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        P3M15D – Every 3 months and 15 days
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        P2M – Every 2 months
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        P150D – Every 150 days
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingFrequency(String retrainingFrequency);

        /**
         * <p>
         * The number of past days of data that will be used for retraining.
         * </p>
         * 
         * @param lookbackWindow
         *        The number of past days of data that will be used for retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackWindow(String lookbackWindow);

        /**
         * <p>
         * Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be
         * used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the
         * new models will not be used <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         * >until they are manually activated</a>.
         * </p>
         * 
         * @param promoteMode
         *        Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will
         *        automatically be used for inference if they have better performance than the current model. In
         *        <code>MANUAL</code> mode, the new models will not be used <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         *        >until they are manually activated</a>.
         * @see ModelPromoteMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPromoteMode
         */
        Builder promoteMode(String promoteMode);

        /**
         * <p>
         * Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be
         * used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the
         * new models will not be used <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         * >until they are manually activated</a>.
         * </p>
         * 
         * @param promoteMode
         *        Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will
         *        automatically be used for inference if they have better performance than the current model. In
         *        <code>MANUAL</code> mode, the new models will not be used <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         *        >until they are manually activated</a>.
         * @see ModelPromoteMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPromoteMode
         */
        Builder promoteMode(ModelPromoteMode promoteMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private Instant retrainingStartDate;

        private String retrainingFrequency;

        private String lookbackWindow;

        private String promoteMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRetrainingSchedulerRequest model) {
            super(model);
            modelName(model.modelName);
            retrainingStartDate(model.retrainingStartDate);
            retrainingFrequency(model.retrainingFrequency);
            lookbackWindow(model.lookbackWindow);
            promoteMode(model.promoteMode);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        public final String getPromoteMode() {
            return promoteMode;
        }

        public final void setPromoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
        }

        @Override
        public final Builder promoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
            return this;
        }

        @Override
        public final Builder promoteMode(ModelPromoteMode promoteMode) {
            this.promoteMode(promoteMode == null ? null : promoteMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRetrainingSchedulerRequest build() {
            return new UpdateRetrainingSchedulerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
