/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateActiveModelVersionRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<UpdateActiveModelVersionRequest.Builder, UpdateActiveModelVersionRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(UpdateActiveModelVersionRequest::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ModelVersion").getter(getter(UpdateActiveModelVersionRequest::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_VERSION_FIELD));

    private final String modelName;

    private final Long modelVersion;

    private UpdateActiveModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
    }

    /**
     * <p>
     * The name of the machine learning model for which the active model version is being set.
     * </p>
     * 
     * @return The name of the machine learning model for which the active model version is being set.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version of the machine learning model for which the active model version is being set.
     * </p>
     * 
     * @return The version of the machine learning model for which the active model version is being set.
     */
    public final Long modelVersion() {
        return modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActiveModelVersionRequest)) {
            return false;
        }
        UpdateActiveModelVersionRequest other = (UpdateActiveModelVersionRequest) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateActiveModelVersionRequest").add("ModelName", modelName())
                .add("ModelVersion", modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateActiveModelVersionRequest, T> g) {
        return obj -> g.apply((UpdateActiveModelVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateActiveModelVersionRequest> {
        /**
         * <p>
         * The name of the machine learning model for which the active model version is being set.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model for which the active model version is being set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version of the machine learning model for which the active model version is being set.
         * </p>
         * 
         * @param modelVersion
         *        The version of the machine learning model for which the active model version is being set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(Long modelVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private Long modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActiveModelVersionRequest model) {
            super(model);
            modelName(model.modelName);
            modelVersion(model.modelVersion);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Long getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActiveModelVersionRequest build() {
            return new UpdateActiveModelVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
